% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readActigraph.R
\name{readActigraph}
\alias{readActigraph}
\title{Read ActiGraph Accelerometer Data}
\usage{
readActigraph(datfile, convertTime = TRUE)
}
\arguments{
\item{datfile}{An AGD file.}

\item{convertTime}{Convert the timestamp from a character string into
POSIXct.}
}
\value{
A data frame with accelerometer data.
}
\description{
This function reads an ActiGraph AGD file into R as a data frame.
If accelerometer data are collected with three axes, it creates vector magnitude
(vm). The counts at any axis or "vm" can be used to classify with wear and 
nonwear time using \code{\link{wearingMarking}}.
}
\details{
AGD files are SQLite databases. This function requires the \pkg{RSQLite}
package.
}
\examples{
\dontrun{
dat <- readActigraph("actfile.agd")
dat1s <- wearingMarking(dataset = dat,
                       frame = 90,
                       perMinuteCts = 1,
                       TS = "TimeStamp",
                       cts = "axis1",
                       streamFrame = NULL,
                       allowanceFrame= 2,
                       newcolname = "wearing",
                       getMinuteMarking = FALSE)
}
}
\seealso{
\code{\link{wearingMarking}}, \code{\link{queryActigraph}}
}
\author{
Cole Beck \email{cole.beck@vumc.org}
}
