% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chl.R
\name{Chl}
\alias{Chl}
\title{Chlorophyll concentration from non-destructive indices (Chl)}
\usage{
Chl(Gen, SPAD_PI, CCI_PI)
}
\arguments{
\item{Gen}{Character vector of Genotype IDs.}

\item{SPAD_PI}{Numeric vector of SPAD (Soil-Plant Analysis Development) values for phase I (PI).}

\item{CCI_PI}{Numeric vector of CCI (Chlorophyll Content Index) values for phase I (PI).}
}
\value{
A list of output columns:
\itemize{
\item \code{Gen}: Character vector of genotype IDs.
\item \code{TCHLSPAD}: total chlorophyll content derived from SPAD (Soil-Plant Analysis Development) value (TCHLSPAD).
\item \code{TCHLCCI}: total chlorophyll content derived from CCI (Chlorophyll Content Index) value (TCHLCCI).
}
}
\description{
This function computes total chlorophyll content derived from SPAD (Soil-Plant Analysis Development) value (TCHLSPAD), and total chlorophyll content derived from CCI (Chlorophyll Content Index) value (TCHLCCI). For more details see Krishnapriya et al. (2020) \url{doi:10.37580/JSR.2019.2.9.150-163}.
}
\examples{
# Creating a sample dataset
Gen = c("V1","V2","V3")
SPAD_PI = c(43.1,44.6,38.6)
CCI_PI  = c(27.3,30.4,21.3)
Chl(Gen, SPAD_PI, CCI_PI)

}
\references{
Krishnapriya, V., Arunkumar, R., Gomathi, R. and Vasantha, S. (2020). \url{doi:10.37580/JSR.2019.2.9.150-163}.
}
