% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoparam.R
\encoding{UTF-8}
\name{summary.param}
\alias{summary.param}
\title{Summarize global phytosociological parameters}
\usage{
\method{summary}{param}(object, ...)
}
\arguments{
\item{object}{An object of class \code{param} returned by \code{\link{phytoparam}}.}

\item{...}{Ignored.}
}
\value{
Used mainly for its side effect of printing to the console.
  Invisibly returns the displayed \code{data.frame}.
}
\description{
Display a concise summary of the global parameters computed by \code{\link{phytoparam}}.
If family-level outputs are present (i.e., the string "N. of families" occurs
in the first column of \code{object$global}), the first seven rows are shown;
otherwise, the first six rows are shown.
}
\details{
Row names of \code{object$global} are removed before printing.
The function is intended for quick inspection of the main global metrics.
}
\examples{
\donttest{
res <- phytoparam(x = quadrat.df, measure.label = "CBH",
                  taxon = "Species", family = "Family",
                  su = "Plot", su.size = 25)
summary(res)  # calls summary.param (S3)
}

}
\seealso{
\pkg{PhytoIn} (\code{\link{phytoparam}}, \code{\link{plot.param}}.
}
