# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' 
#' @title Probability of disease calculation
#'
#' @description Function calculates probability of disease (PoD) for given titers according to a PoD curve.
#'
#' @param titer numeric vector: vector of subject level titers
#' @param pmax numeric: maximum PoD
#' @param et50 numeric: titer value corresponding to pmax/2 value, PoD(et50) = pmax/2
#' @param slope numeric: slope of the PoD curve
#' @param adjustTiters boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function
#' @param adjustFrom numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value
#' @param adjustTo numeric: value to which titers below the detection limit will be adjusted
#'
#' @return vector of PoDs
#'
#' @usage
#' cppPoD(titer, pmax, et50, slope, adjustTiters = FALSE, adjustFrom = 0, adjustTo = 0)
#' 
#' @details 
#' See \code{PoD} function for more details. These two functions are equivalent. Usage of cppPoD significantly improves the computation speed over the \code{PoD} function.
#' 
#' @export
cppPoD <- function(titer, pmax, et50, slope, adjustTiters = FALSE, adjustFrom = 0, adjustTo = 0) {
    .Call('_PoDBAY_cppPoD', PACKAGE = 'PoDBAY', titer, pmax, et50, slope, adjustTiters, adjustFrom, adjustTo)
}

