% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPODBAYEfficacy.R
\name{PoDBAYEfficacy}
\alias{PoDBAYEfficacy}
\title{PoDBAY efficacy estimation}
\usage{
PoDBAYEfficacy(estimatedParameters,
              blindVaccinated,
              blindControl,
              adjustTiters = FALSE,
              adjustFrom = log2(10),
              adjustTo = log2(5))
}
\arguments{
\item{estimatedParameters}{named data frame ("pmax", "slope", "et50"): set of estimated PoD curve parameters}

\item{blindVaccinated}{\code{Population-class} object: vaccinated subjects from immunogenicity subset, containing N, mean, standard deviation information}

\item{blindControl}{\code{Population-class} object: control subjects from immunogenicity subset, containing N, mean, standard deviation information}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
efficacySet, set of PoDBAY effficacies corresponding to estimated set of PoD curve parameters
}
\description{
Function calculates the PoDBAY efficacy based on the set of PoD curve parameters calculated in \code{PoDParamEstimation} function, vaccinated and control immunogenicity subset means and standard deviations.
}
\details{
Application of \code{efficacyComputation} function to the all PoD curves (each characterized by three PoD parameters) estimated by \code{PoDParamEstimation} function.

Inputs into the \code{efficacyComputation} are:
\itemize{
  \item PoDParameters: i'th estimated PoD parameters from \code{PoDParamEstimation}. i = 1, ..., N, where N = number of estimations in which MLE converges. See \code{PoDMLE} for details.

  \item means: jittered means of immunogenicity subset. See \code{JitterMeans} for details.

  \item standardDeviations: standard deviations of the vaccinated and control subjects from the immunogenicity subset.
}
}
\examples{
## Data preparation
data(diseased)
data(nondiseased)
data(estimatedParameters)

## Example 1
# Creating imunogenicity subset, method = "Ratio", value = 4
ImmunogenicitySubset <- 
  BlindSampling(diseased, 
                nondiseased, 
                method = list(name = "Ratio", 
                              value = 4))
                              
# Estimating PoD curve parameters
nondiseasedGenerationCount <- nondiseased$N

estimatedParameters <- PoDParamEstimation(diseased$titers,
                       ImmunogenicitySubset$ImmunogenicityNondiseased$titers,
                       nondiseasedGenerationCount,
                       repeatCount = 10)
                       
# Estimating PoDBAY efficacy  
PoDBAYEfficacy(estimatedParameters$results,
              ImmunogenicitySubset$ImmunogenicityVaccinated,
              ImmunogenicitySubset$ImmunogenicityControl)

}
