% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{PoDEfficacySquaredError}
\alias{PoDEfficacySquaredError}
\title{Optimization function: finds PoD curve paramaters (et50, slope)}
\usage{
PoDEfficacySquaredError(TrueEfficacy, 
                        vaccinated, 
                        control,
                        initialSlope = 6,
                        adjustTiters = FALSE, 
                        adjustFrom = NA, 
                        adjustTo = NA)
}
\arguments{
\item{TrueEfficacy}{numeric: input reference efficacy}

\item{vaccinated}{\code{Population-class} object: vaccinated group (mean, sd)}

\item{control}{\code{Population-class} object: control group (mean, sd)}

\item{initialSlope}{numeric: initial slope parameter for the optimization function}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
PoD curve parameters (et50, slope)
}
\description{
Function finds PoD curve parameters (et50, slope) using population summary statistics (mean, sd) and input (reference value, or for example true in the simulation setup) efficacy. 
Efficacy is independent of pmax parameter thus pmax is estimated separately using \code{PmaxEstimation} function.
}
\details{
Function returns et50 and slope PoD curve parameters obtained using \code{efficacySquaredError} 
i.e. the opimal (output) parameters et50 and slope correspond to the minimal squared difference between input reference efficacy and calculated efficacy. 

Pmax parameter is not obtained as efficacy is independent on pmax. 

The \code{optim} function is used for optimization with method = "L-BFGS-B", 1000 maximum itiretations, (0.1,Inf) boundaries for et50 and (-slopeBoundary, slopeBoundary) boundaries for slope.

NOTE: The reason for slope boundary settings is because from certain value of slope parameter the shape of the PoD curve and the corresponding PoD values for given titers are almost identical. 
This parameter is supposed to limit the resulting slope value and help MLE to converge to optimal parameters.
The value of "slopeBoundaries" is calculated from data according to Dunning, 2015 (https://doi.org/10.1186/s12874-015-0096-9).
}
\examples{

## Example 1
data(vaccinated)
data(control)

# Assigning reference efficacy 
TrueEfficacy <- 0.53

# PoD curve parameter estimation
PoDEfficacySquaredError(TrueEfficacy, vaccinated, control)

}
