% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{efficacySquaredError}
\alias{efficacySquaredError}
\title{Optimization objective function: efficacy squared error}
\usage{
efficacySquaredError(params, 
                     TrueEfficacy, 
                     titerFun,
                     adjustTiters = FALSE,
                     adjustFrom = 0,
                     adjustTo = 0)
}
\arguments{
\item{params}{numeric vector: vector of et50 and slope; efficacy calculation is independent of Pmax and thus Pmax is excluded}

\item{TrueEfficacy}{numeric value: input efficacy value}

\item{titerFun}{list: list of probability density functions for vaccinated and control groups}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
Squared difference between calculated and reference efficacy
}
\description{
Function calculates squared difference between input (reference value, or for example true in the simulation setup) efficacy and
efficacy calculated based on input parameters of PoD curve and input titer 
distributions of vaccinated and control groups.
}
\details{
Function is used inside the \code{PoDEfficacySquaredError} function for calculation of the PoD parameters.
}
\examples{

## Example 1
data(vaccinated)
data(control)
data(PoDParams)

# Choosing et50 and slope as the inputs
params <- list("et50" = 4, "slope" = 6)

# Using probability density function from the populations

titerFun <- 
  list(
      function(x) {dnorm(x, mean = vaccinated$mean, sd = vaccinated$stdDev)},
      function(x) {dnorm(x, mean = control$mean, sd = control$stdDev)}
      )

# Assigning true efficacy
TrueEfficacy <- 0.53

# Sqaured difference between true and calcuated efficacy
efficacySquaredError(params, TrueEfficacy, titerFun)

}
