% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polytree.R
\name{polytree}
\alias{polytree}
\title{Causal Polytree Estimation}
\usage{
polytree(x)
}
\arguments{
\item{x}{Data matrix, whose rows are i.i.d. data vectors generated from the model.}
}
\value{
A directed polytree estimated from the input data, as an igraph object.
}
\description{
Estimates directed causal polytree from data, using algorithm developed in Chatterjee and Vidyasagar (2022).
}
\examples{
p <- 10
n <- 200
x <- matrix(nrow = n, ncol = p)
for (i in 1:n) {
   x[i,1] = rnorm(1)
   for (j in 2:p) {
      x[i,j] = (x[i,j-1] + rnorm(1))/sqrt(2)
   }
}
p <- polytree(x)
}
\references{
Sourav Chatterjee and Mathukumalli Vidyasagar (2022). Estimating large causal polytrees from small samples. Available at \url{https://arxiv.org/abs/2209.07028}
}
