% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chiKappa}
\alias{chiKappa}
\title{Chi-squared kappa for a given centrality quotient}
\usage{
chiKappa(
  cq,
  M,
  alpha = 0.05,
  interval = c(0, 100),
  tol = .Machine$double.eps^0.5
)
}
\arguments{
\item{cq}{numeric between 0 and 1}

\item{M}{integer sample size greater than 0}

\item{alpha}{numeric between 0 and 1}

\item{interval}{numeric of length 2, where should roots be sought?}

\item{tol}{numeric, how close do values need to be for equality?}
}
\value{
A numeric within interval.
}
\description{
Computes the kappa (degrees of freedom) required
to obtain a given centrality quotient using the chi-square pooled
p-value.
}
\details{
This function is essentially a wrapper for uniroot which
finds where chiCentQuot gives an output equal to the given
centrality quotient to provide an approximate kappa giving that
quotient.
}
\examples{
chiKappa(0.5, 10, 0.05)
chiKappa(0.5, 20, 0.05)
chiKappa(0.5, 100, 0.05, interval = c(0, 10))
}
\author{
Chris Salahub
}
