% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr.R
\name{hrPool}
\alias{hrPool}
\title{Empirical UMP beta pooled p-value}
\usage{
hrPool(w = 1, M = 10, nsim = 1e+05)
}
\arguments{
\item{w}{numeric value between 0 and 1}

\item{M}{integer, the number of tests to pool}

\item{nsim}{integer, the number of simulated null cases generated}
}
\value{
A closure which accepts a vector of values between 0 and 1
and returns a single numeric between 0 and 1
}
\description{
Uses simulation under the null to approximate the UMP
pooled p-value for a restricted beta family.
}
\details{
To test the null hypotheses that all p-values are uniform
against a restricted beta family 0 < a <= 1 <= b, the most
powerful pooled p-value linearly combines upper and lower tail
probabilities of the chi-squared distribution with two degrees
of freedom with weights w and (1 - w) where w = (1 - a)/(b - a).

This function computes the statistic given by this combination
for a collection of p-values, and then simulates a specified
number of null cases to give an empirical pooled p-value. It
produces a closure so that the time-intensive simulation step
doesn't need to be repeated.
}
\examples{
p <- c(0.1, 0.5, 0.9)
hr2 <- hrPool(w = 0.2, M = 3)
hr2(p)
hr5 <- hrPool(w = 0.5, M = 3, nsim = 100)
hr5(p)
}
\author{
Chris Salahub
}
