% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependentChi.R
\name{satterApproxP}
\alias{satterApproxP}
\title{Satterthwaite p-values}
\usage{
satterApproxP(qs, covmat, kappa)
}
\arguments{
\item{qs}{M numeric values (observed chi-squared values)}

\item{covmat}{M by M covariance matrix of qs}

\item{kappa}{degrees of freedom of qs}
}
\value{
a numeric in [0,1], the p-value of the sum
}
\description{
p-value of the sum of dependent chi-squared using
the Satterthwaite approximation for the degrees of freedom.
}
\details{
Computes the p-value of an observed vector of chi-squared
variables using the Satterthwaite approximation. This approximates
the sum of dependent chi-squared variables with a scaled
chi-squared distribution with degrees of freedom chosen to match
the first two moments of the dependent sum.
}
\author{
Chris Salahub
}
