% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preknit_posthtmlrender.R
\name{preknit_knit_render_postrender}
\alias{preknit_knit_render_postrender}
\title{First Pre-knitting Processing, then knitr::knit, then rmarkdown::render,
then Post HTML-rendering Processing}
\usage{
preknit_knit_render_postrender(pRmdfile, outhtml = NULL)
}
\arguments{
\item{pRmdfile}{- input Rmd file}

\item{outhtml}{- output html file}
}
\value{
The output html file will have the codes between @@@
and/or \`\%\%\% \` (where \` is a backtick) code chunks evaluated
}
\description{
1) In pre-knitting processing, function takes in a Rmd file, evaluates code chunks
which are marked as between adjacent lines of @@@s, and then
replace these code chunks with evaluated output captured using capture.output function.
2) Function then calls knitr::knit followed by rmarkdown::render.
3) After which, in post HTML-rendering processing, function evaluates code chunks
in between `%%% MY_CODE_HERE `, and then replace these code chunks with evaluated output
captured using capture.output function. Typically, we want to insert an external HTML file
and we can use `%%% writeLines(readLines("MY_EXTERNAL_HTML_FILE"))` within the Rmd file.
This function will read in the external html file and replace this `%%% ` with
contents in the html file.
}
\examples{
\donttest{
oldwd <- getwd()
setwd(tempdir())

#pandoc.exe is required to run this code
samplermd <- tempfile('test', getwd(), '.Rmd')
addhtml <- 'test__test.html'

#generate the test Rmd file
writeLines(c('---',
'title: "Example Usage"',
'output: html_document',
'---',
'',
'This document is used for various similar reports.',
'',
'@@@',
"cat(paste('#Dynamic Header1', rnorm(1)))",
'@@@',
'',
'`\%\%\% writeLines(readLines("test__test.html"))`',
'',
'@@@',
'cat(paste("##Dynamic Header2", rnorm(1)))',
'@@@',
'',
'Some content is invariant across different reports.'), samplermd)

#generate test html file
writeLines(c('<ul>',
'<li>Item 1</li>',
'<li>Item 2</li>',
'<li>Item 3</li>',
'</ul>'), addhtml)

#Pre-knit processing and post HTML render processing
preknit_knit_render_postrender(samplermd, "sample__html.html")

#output 'sample__html.html' is in tempdir()

setwd(oldwd)
}

}

