% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeEntryWisePerturbationExpectation.R
\name{ComputeEntryWisePerturbationExpectation}
\alias{ComputeEntryWisePerturbationExpectation}
\title{Compute Entry Wise Perturbation Expectation}
\usage{
ComputeEntryWisePerturbationExpectation(
  input_folder = NULL,
  PreProsMatrix = NULL,
  prefix = NULL,
  distribution_type = "truncnorm",
  input_a = 0,
  input_b = -2,
  threads = 1
)
}
\arguments{
\item{input_folder}{Input folder. The location of the files created by PreprocessMatrix
if you specified an output_folder. If this option is specified, this
is also where the num switch array will be saved. Must specify an 
input_folder OR PreProsMatrix. Default: NULL}

\item{PreProsMatrix}{Object where the PreprocessMatrix output was saved.
Must specify an input_folder OR PreProsMatrix. Default: NULL}

\item{prefix}{Prefix of output files, if you so choose.}

\item{distribution_type}{Kind of distribution to use. Valid choices are: 
truncnorm, uniform, trunc_lognorm, beta. Default: “truncnorm”}

\item{input_a}{First parameter to the distribution you choose. For truncnorm, this is the mean.
Default: 0}

\item{input_b}{First parameter to the distribution you choose. For truncnorm, this is the variance.
Using a negative value indicates you want the standard deviation to be the length of the 
interval divided by the absolute value of the input parameter. Default: -2}

\item{threads}{Number of threads to use. Default: 1}
}
\value{
If an input folder is specified the objects will be saved to that folder.
If the PreProsMatrix object is specified, an R list object with the following: 
original_matrix, matrix_size, column_names, row_names,
non_zero, num_switch_functions, asymptotic_stability_start, 
asymptotic_stability_end, num_switch_funcs_r, distributions,
expected_num_switch, distributions_object
}
\description{
This function computes the expected number of sign switches from perturbing 
each entry individually. Run after PreprocessMatrix().
}
\examples{
\dontrun{
# Set input file
infile <- system.file("extdata", "Modules", "IGP.csv", 
    package = "PressPurt")
# Preprocess the matrix
PreProsMatrix <- PreprocessMatrix(input_file = infile, 
    output_folder = NULL, max_bound = 10, threads = 2)
# Run ComputeEntryWisePerturbationExpectation
Entrywise <- ComputeEntryWisePerturbationExpectation(PreProsMatrix = PreProsMatrix,
    distribution_type = "truncnorm", 
    input_a = 0, input_b = -2, threads = 1)
}
}
