% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funcs.R
\name{ns_to_step}
\alias{ns_to_step}
\title{Num Switch Function to step function}
\usage{
ns_to_step(asymp_stab_start, asymp_stab_end, num_switch_func)
}
\arguments{
\item{asymp_stab_start}{start interval from asymptotic_stability}

\item{asymp_stab_end}{end interval from asymptotic_stability}

\item{num_switch_func}{a single num switch function}
}
\value{
plot ready x and y values from the Num Switch Function
}
\description{
This function transforms a Num Switch Function
to a plot ready step function with x and y values.
Returns a data frame of x and y values to plot.
}
\examples{
\dontrun{
# Set input file
infile <- system.file("extdata", "Modules", "IGP.csv", 
    package = "PressPurt")
# Preprocess the matrix
PreProsMatrix <- PreprocessMatrix(input_file = infile, 
    output_folder = NULL, max_bound = 10, threads = 2)

# Run ComputeEntryWisePerturbationExpectation
Entrywise <- ComputeEntryWisePerturbationExpectation(
    PreProsMatrix = PreProsMatrix,
    distribution_type = "truncnorm", 
    input_a = 0, input_b = -2, threads = 1)

ns_step <- ns_to_step(
    asymp_stab_start = Entrywise$asymptotic_stability_start[1,1],
    asymp_stab_end = Entrywise$asymptotic_stability_end[1,1],
    num_switch_func = Entrywise$num_switch_funcs_r$`(1, 1)`)
}
}
