% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitSpatial.R
\name{predict.ProbitSpatial}
\alias{predict.ProbitSpatial}
\title{Spatial probit model predictions.}
\usage{
\method{predict}{ProbitSpatial}(
  object,
  X,
  type = c("link", "response", "binary"),
  cut = 0.5,
  oos = FALSE,
  WSO = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{ProbitSpatial}.}

\item{X}{a matrix of explanatory variables. If oos=TRUE, it may contain more 
observations than the dataset on which the model has been trained}

\item{type}{the type of output: 
\describe{
  \item{\code{"link"}}{the value of the latent variable. Default}
  \item{\code{"response"}}{probability.}
  \item{\code{"binary"}}{binary 0/1 output.}
}}

\item{cut}{the threshold probability for the \code{"binary"} type. 
Default is 0.5.}

\item{oos}{logical. If TRUE, out-of-sample predictions are returned.}

\item{WSO}{W matrix containing weights of in-sample and 
out-of-sample data. Observations must be ordered in such a way that
the first elements belong to the in-sample data and the remaining ones
to the out-of-sample data.}

\item{...}{ignored}
}
\value{
Returns a vector of predicted values for the set \code{X} of 
	covariates if \code{oos=FALSE} or the best linear unbiased predictors of the #' set \code{XOS} if \code{oos=TRUE}.
}
\description{
Predicts of a \code{ProbitSpatial} model on a set \code{X} of covariates.
Works on both in-sample and out-of-sample using BLUP formula from Goulard et 
al. (2017)
}
\details{
If \code{oos=FALSE}, the function computes the predicted values for  #' the estimated model (same as \code{fitted}). Otherwise, it applies the BLUP #' formula of Goulard et al. (2017):
\deqn{\hat{y} = (\hat(y_S),\hat(y_O)),}
where the sub-indexes S and O refer, respectively, to the in-sample and
out-of-sample data. \eqn{\hat{y_S}} corresponds to fitted values, while
\eqn{\hat{y_O}} is computed as follows:
\deqn{\hat{y_O} = (I-\rho W)^{-1}(X\beta)-Q_{OO}^{-1}Q_{OS}(y_S-\hat{y_S}),}
where \eqn{Q} is the precision matrix of 
\eqn{\Sigma=\sigma^2((I-\rho W)'(I-\rho W))^{-1}.} and the sub-indexes OO and 
OS refer to the corresponding block matrices.
}
\references{
\describe{
\item{Goulard et al. (2017)}{M. Goulard, T. Laurent and C. Thomas-Agnan. 
About predictions in spatial autoregressive models: optimal and almost
 optimal strategies. \emph{Spatial Economic Analysis} 12, 304-325, 2017.}}
}
