% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_extraction.R
\name{seq2feature_mds_large}
\alias{seq2feature_mds_large}
\title{Feature Extraction by MDS for Large Dataset}
\usage{
seq2feature_mds_large(seqs, K, dist_type = "oss_action", subset_size,
  subset_method = "random", n_cand = 10, pca = TRUE, L_set = 1:3)
}
\arguments{
\item{seqs}{an object of class \code{"\link{proc}"}}

\item{K}{the number of features to be extracted.}

\item{dist_type}{a character string specifies the dissimilarity measure for two
response processes. See 'Details'.}

\item{subset_size}{the size of the subset on which classical MDS is performed.}

\item{subset_method}{a character string specifying the method for choosing the subset.
It must be one of \code{"random"}, \code{"sample_avgmax"},
\code{"sample_minmax"}, \code{"full_avgmax"}, and \code{"full_minmax"}.}

\item{n_cand}{The size of the candidate set when selecting the subset. It is only used when 
\code{subset_method} is \code{"sample_avgmax"} or \code{"sample_minmax"}.}

\item{pca}{logical. If \code{TRUE} (default), the principal components of the
extracted features are returned.}

\item{L_set}{length of ngrams considered}
}
\value{
\code{seq2feature_mds_large} returns an \eqn{n \times K} matrix of extracted 
features.
}
\description{
\code{seq2feature_mds_large} extracts MDS features from a large number of 
response processes. The algorithm proposed in Paradis (2018) is implemented with minor 
variations to perform MDS. The algorithm first selects a relatively small subset of 
response processes to perform the classical MDS. Then the coordinate of each of the 
other response processes are obtained by minimizing the loss function related to the target
response processes and the those in the subset through BFGS.
}
\references{
Paradis, E. (2018). Multidimensional Scaling with Very Large Datasets. 
  \emph{Journal of Computational and Graphical Statistics}, 27, 935--939.
}
\seealso{
Other feature extraction methods: \code{\link{aseq2feature_seq2seq}},
  \code{\link{atseq2feature_seq2seq}},
  \code{\link{seq2feature_mds}},
  \code{\link{seq2feature_ngram}},
  \code{\link{seq2feature_seq2seq}},
  \code{\link{tseq2feature_seq2seq}}
}
\concept{feature extraction methods}
