% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{respiratory_clinical_trial_df}
\alias{respiratory_clinical_trial_df}
\title{Respiratory Clinical Trial}
\format{
A data frame with 444 observations and 8 variables:
\describe{
  \item{center}{Study identifier (integer vector)}
  \item{id}{Patient identifier (integer vector)}
  \item{treat}{Treatment group (factor with 2 levels)}
  \item{sex}{Patient sex (factor with 2 levels)}
  \item{age}{Patient age in years (integer vector)}
  \item{baseline}{Baseline respiratory status (integer vector)}
  \item{visit}{Visit number (integer vector)}
  \item{outcome}{Respiratory status (integer vector)}
}
}
\source{
Data taken from the geepack package version 1.3.12
}
\usage{
data(respiratory_clinical_trial_df)
}
\description{
This dataset, respiratory_clinical_trial_df, is a data frame containing information from a clinical trial
of patients with respiratory illness, where 111 patients from two different clinics were randomized to receive
either placebo or an active treatment. Patients were examined at baseline and at four visits during treatment.
The respiratory status was determined at each visit, with 1 representing good status and 0 representing poor status.
}
\details{
The dataset name has been kept as 'respiratory_clinical_trial_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PulmoDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
