% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Binary.R
\name{BinaryBS}
\alias{BinaryBS}
\title{Binary option valuation with Black-Scholes (BS) model}
\usage{
BinaryBS(o = OptPx(Opt(Style = "Binary")), Q = 1,
  Type = c("cash-or-nothing", "asset-or-nothing"))
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{Q}{A fixed amount of payoff}

\item{Type}{Binary option type: 'Cash or Nothing' or 'Asset or Nothing'.
Partial names are allowed, eg. \code{'C'} or \code{'A'}}
}
\value{
A list of class \code{Binary.BS} consisting of the input object \code{OptPx} and the appended new parameters and option price.
}
\description{
S3 object pricing model for a binary option.
Two types of binary options are priced: \code{'cash-or-nothing'} and \code{'asset-or-nothing'}.
}
\examples{
(o = BinaryBS())$PxBS

#This example should produce price 4.33 (see Derivagem, DG201.xls)
o = Opt(Style="Binary", Right='Call', S0=50, ttm=5/12, K=52)
o = OptPx(o, r=.1, vol=.40, NSteps=NA)
(o = BinaryBS(o, Q = 10, Type='cash-or-nothing'))$PxBS

BinaryBS(OptPx(Opt(Style="Binary"), q=.01), Type='asset-or-nothing')
BinaryBS(OptPx(Opt(Style="Binary", S0=100, K=80),q=.01))
o = Opt(Style="Binary", Right="Put", S0=50, K=60)
BinaryBS(OptPx(o,q=.04), Type='asset-or-nothing')
}
\author{
Xinnan Lu, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
pp.606-607
}

