% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QI_F.R
\name{QIlin}
\alias{QIlin}
\title{Quantity-intensity relationship derived through linear regression}
\usage{
QIlin(Solution2Soil = Solution2Soil, CKi = CKi, CKf = CKf, CCaMg = CCaMg,
NH4OAC_K = NH4OAC_K)
}
\arguments{
\item{Solution2Soil}{Ratio of solution volume to soil mass (mL/g or L/kg)}

\item{CKi}{Initial K concentration (mg/L)}

\item{CKf}{Final or equilibrium K concentration (mg/L)}

\item{CCaMg}{Final or equilibrium 'Ca+Mg' concentration (mol/L)}

\item{NH4OAC_K}{K extracted from soil by 1 N ammonium acetate (NH4OAc) of pH 7 (mg/kg)}
}
\value{
AReK - Equilibrium activity ratio (unitless)
-deltaK0 - Non-specifically held K (cmolc/kg)
Ks - Specifically held K (cmolc/kg)
PBCK - Potential buffering capacity (cmolc/kg)
deltaG0 - The standard free energy of exchange (cal/mol)
}
\description{
The quantity-intensity (Q/I) relationships of soil K, introduced by Beckett (1964), is implemented in this function using linear regression equation as used by some earlier workers (Zhang et al., 2011; Islam et al., 2017; Das et al., 2019; 2021).
}
\details{
A number of parameters related to soil K availability can be obtained from the Q/I plot, e.g., equilibrium activity ratio (AReK), total labile K (KL), non-specifically held K (-deltaK0), specifically held K (Ks), potential buffering capacity (PBCK), and standard free energy of exchange (deltaG0). The equilibrium activity ratio (AReK) is defined as the activity ratio of K to Ca or 'Ca+Mg' when there is no net adsorption or desorption of K between soil solution and exchange phases. It is a measure of the intensity factor. Total labile K is the amount of K held on the soil solids which is capable of ion exchange reactions during the time period provided for equilibration between soil solution and soil solids. It is a measure of the quantity factor. Conventionally, the total labile K has been sub-divided into non-specifically held K, which is mainly bound to the planar sites; and specifically held K, which is mainly bound to the edge/wedge positions of 2:1 clay minerals (Sparks and Liebhardt, 1981). The potential buffering capacity (PBCK) is a measure of the ability of a soil to resist the changes in intensity factor after additions or losses of K from the system.
}
\examples{
with(data = df, QIlin(Solution2Soil = Solution_to_Soil_Ratio, CKi = Initial_K,
CKf = Final_K, CCaMg = Final_Ca_and_Mg, NH4OAC_K = 55))
}
\references{
Beckett, P.H.T., 1964. The immediate Q/I relations of labile potassium in the soil. European Journal of Soil Science 19, 9-23.

Bilias, F., Barbayiannis, N., 2018. Contribution of non-exchangeable potassium on its quantity-intensity relationships under K-depleted soils. Archives of Agronomy and Soil Science 64, 1988-2004.

Das, D., Dwivedi, B.S., Datta, S.P., Datta, S.C., Meena, M.C., Agarwal, B.K., Shahi, D.K., Singh, M., Chakraborty, D., Jaggi S., 2019. Potassium supplying capacity of a red soil from eastern India after forty-two years of continuous cropping and fertilization. Geoderma 341: 76-92.

Das D, Dwivedi BS, Datta SP, Datta SC, Meena MC, Dwivedi AK, Singh M, Chanraborty D, Jaggi S (2021) Long-term differences in nutrient management under intensive cultivation alter potassium supplying ability of soils. Geoderma 393:114983.

Das, D., Nayak, A.K., Thilagam, V.K., Chatterjee, D., Shahid, M., Tripathi, R., Mohanty, S., Kumar, A., Lal, B., Gautam, P., Panda, B.B., Biswas, S.S., 2018. Measuring potassium fractions is not sufficient to assess the long-term impact of fertilization and manuring on soil's potassium supplying capacity. Journal of Soils and Sediments 18, 1806-1820.

Evangelou, V.P., Blevins, R.L., 1988. Effect of long-term tillage systems and nitrogen addition on potassium quantity-intensity relationships. Soil Sci. Soc. Am. J. 52, 1047-1054.

Islam, A., Karim, A.J.M.S., Solaiman, A.R.M., Islam, M.S., Saleque, M.A., 2017. Eight-year long potassium fertilization effects on quantity/intensity relationship of soil potassium under double rice cropping. Soil Till. Res. 169, 99-117.

Le Roux, J., Summer, M.E., 1968. Labile potassium in soils, I: Factors affecting the quantity-intensity (Q/I) parameters. Soil Science 106, 35-41.

Sparks, D.L., Liebhardt, W.C., 1981. Effect of long-term lime and potassium application on quantity-intensity (Q/I) relationships in sandy soil. Soil Science Society of America Journal 45,786-790.

Zhang, H., Xu, M., Zhu, P., Peng, C., 2011. Effect of 15-year-long fertilization on potassium quantity/intensity relationships in black soil in Northeastern China. Communications in Soil Science and Plant Analysis 42, 1289-1297.
}
