% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sq.test.0vs1.R
\name{sq.test.0vs1}
\alias{sq.test.0vs1}
\title{Test for a Structural Break in a Conditional Quantile}
\usage{
sq.test.0vs1(y, x, v.tau, n.size = 1)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{v.tau}{A numeric value representing the quantile level.}

\item{n.size}{An integer specifying the size of the cross-section (\eqn{N}).}
}
\value{
A numeric value representing the test statistic for the presence of a structural break.
}
\description{
The function implements a break test to evaluate whether a single structural break exists at a given quantile.
}
\examples{
## data
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]

## quantile
v.tau = 0.8

# cross-sectional size
n.size = 1

# sq test: 0 vs 1
result = sq.test.0vs1(y, x, v.tau, n.size)
print(result)

}
\references{
Koenker, R. and G. Bassett Jr, (1978).
Regression Quantiles. \emph{Econometrica}, \emph{46}(1), 33–50.

Qu, Z. (2008).
Testing for Structural Change in Regression Quantiles.
\emph{Journal of Econometrics}, \emph{146}(1), 170–184.
}
