% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WenF.r
\name{WenS}
\alias{WenS}
\title{The second step of Wen method}
\usage{
WenS(
  flag = NULL,
  CriLOD = NULL,
  NUM = NULL,
  pheRaw = NULL,
  Likelihood = NULL,
  SetSeed = NULL,
  flagrqtl = NULL,
  yygg = NULL,
  mx = NULL,
  phe = NULL,
  chr_name = NULL,
  v.map = NULL,
  gen.raw = NULL,
  a.gen.orig = NULL,
  d.gen.orig = NULL,
  n = NULL,
  names.insert2 = NULL,
  X.ad.tran.data = NULL,
  X.ad.t4 = NULL,
  dir = NULL
)
}
\arguments{
\item{flag}{random or fix model.}

\item{CriLOD}{LOD score.}

\item{NUM}{the number of trait.}

\item{pheRaw}{raw phenotype matrix.}

\item{Likelihood}{likelihood function.}

\item{SetSeed}{random seed set in which,the cross validation is needed.}

\item{flagrqtl}{do CIM or not.}

\item{yygg}{covariate matrix.}

\item{mx}{raw genotype matrix.}

\item{phe}{phenotype matrix.}

\item{chr_name}{chromosome name.}

\item{v.map}{linkage map matrix.}

\item{gen.raw}{raw genotype matrix.}

\item{a.gen.orig}{additive genotype matrix.}

\item{d.gen.orig}{dominant genotype matrix.}

\item{n}{number of individual.}

\item{names.insert2}{linkage map after insert.}

\item{X.ad.tran.data}{genotype matrix after insert.}

\item{X.ad.t4}{genotype matrix.}

\item{dir}{file storage path.}
}
\value{
a list
}
\description{
The second step of Wen method
}
\examples{
data(F2data)
readraw<-Readdata(file=F2data,fileFormat="GCIM",
method="GCIM",filecov=NULL,MCIMmap=NULL,MultiEnv=FALSE)
DoResult<-Dodata(fileFormat="GCIM",Population="F2",
method="GCIM",Model="Random",readraw,MultiEnv=FALSE)
WEN1re<-WenF(pheRaw=DoResult$pheRaw,
genRaw=DoResult$genRaw,mapRaw1=DoResult$mapRaw1,
yygg1=DoResult$yygg1,cov_en=DoResult$cov_en,
WalkSpeed=1,CriLOD=2.5,dir=tempdir())
ws<-WenS(flag=DoResult$flag,CriLOD=2.5,NUM=1,
pheRaw=DoResult$pheRaw,Likelihood="REML",
SetSeed=11001,flagrqtl=FALSE,
yygg=WEN1re$yygg,mx=WEN1re$mx,phe=WEN1re$phe,
chr_name=WEN1re$chr_name,v.map=WEN1re$v.map,
gen.raw=WEN1re$gen.raw,
a.gen.orig=WEN1re$a.gen.orig,
d.gen.orig=WEN1re$d.gen.orig,n=WEN1re$n,
names.insert2=WEN1re$names.insert2,
X.ad.tran.data=WEN1re$X.ad.tran.data,
X.ad.t4=WEN1re$X.ad.t4,dir=tempdir())
}
