% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZhouF.R
\name{ZhouF}
\alias{ZhouF}
\title{To perform QTL mapping with Wen method}
\usage{
ZhouF(
  pheRaw = NULL,
  genRaw = NULL,
  mapRaw1 = NULL,
  WalkSpeed = NULL,
  CriLOD = NULL,
  dir = NULL
)
}
\arguments{
\item{pheRaw}{phenotype matrix.}

\item{genRaw}{genotype matrix.}

\item{mapRaw1}{linkage map matrix.}

\item{WalkSpeed}{Walk speed for Genome-wide Scanning.}

\item{CriLOD}{Critical LOD scores for significant QTL.}

\item{dir}{file path in your computer.}
}
\value{
a list
}
\description{
To perform QTL mapping with Wen method
}
\examples{
data(F2data)
readraw<-Readdata(file=F2data,fileFormat="GCIM",
method="GCIM-QEI",filecov=NULL,
MCIMmap=NULL,MultiEnv=TRUE)
DoResult<-Dodata(fileFormat="GCIM",
Population="F2",method="GCIM-QEI",
Model="Random",readraw,MultiEnv=TRUE)
ZhouMatrices<-ZhouF(pheRaw=DoResult$pheRaw,
genRaw=DoResult$genRaw,
mapRaw1=DoResult$mapRaw1,
WalkSpeed=1,CriLOD=3,
dir=tempdir())
}
