% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPWE_Qopt_DTR_IndCen.R
\name{IPWE_Qopt_DTR_IndCen}
\alias{IPWE_Qopt_DTR_IndCen}
\title{Function to estimate the two-stage quantile-optimal dynamic treatment 
regime for censored data: the independent censoring Case}
\usage{
IPWE_Qopt_DTR_IndCen(data, tau, regimeClass.stg1, regimeClass.stg2,
  s_Diff_Time = 1, moPropen1 = "BinaryRandom",
  moPropen2 = "BinaryRandom", sign_beta1.stg1 = NULL,
  sign_beta1.stg2 = NULL, Penalty.level = 0, s.tol = 1e-06,
  it.num = 4, max = TRUE, Domains1 = NULL, Domains2 = NULL,
  cluster = FALSE, p_level = 1, pop.size = 10000)
}
\arguments{
\item{data}{a data.frame, containing variables in the \code{moPropen} and 
\code{RegimeClass} and also the response variables, namely \code{censor_y} as the censored response, 
and \code{delta} as the censoring indicator.}

\item{tau}{a value between 0 and 1. This is the quantile of interest.}

\item{regimeClass.stg1}{a formula specifying the class of treatment regimes for the first stage. 
For details of the general formulation of a linear treatment regime
 see \code{regimeClass} in \code{\link{IPWE_Qopt_IndCen}}.}

\item{regimeClass.stg2}{a formula specifying the class of treatment regimes for the second stage}

\item{s_Diff_Time}{Numeric. The fixed length of time between the first stage treatment and the
second stage treatment}

\item{moPropen1}{the first stage propensity score model. Default is "BinaryRandom".}

\item{moPropen2}{the second stage propensity score model. Default is "BinaryRandom".}

\item{sign_beta1.stg1}{Is sign of the coefficient for the first non-intercept 
variable for the first stage known? Default is NULL, meaning user does not have contraint on
the sign;
FALSE if the coefficient for the first continuous variable 
is fixed to be \code{-1}; TRUE if \code{1}. We can make the search space discrete because we employ
\eqn{|\beta_1| = 1} scale normalizaion.}

\item{sign_beta1.stg2}{Default is NULL. Similar to \code{sign_beta1.stg1}.}

\item{Penalty.level}{0: stop if the marginal quantiles cannot be further optimized; 1: continue
the search among treatment regimes with with same value for the TR
with the smallest intended proportion of treatment.}

\item{s.tol}{tolerance level for the GA algorithm. This is input for parameter \code{solution.tolerance}
in function \code{rgenoud::genoud}.}

\item{it.num}{the maximum GA iteration number}

\item{max}{logical. TRUE if the goal is maximization of the quantile. FALSE is the goal is minimization of the quantile.}

\item{Domains1}{This is optional. If not NULL, please provide 
the two-column matrix for the searching range of coeffients in stage one.
The coefficient taking value of positive/negative one should not be included.}

\item{Domains2}{This is optional. If not NULL, please provide 
the two-column matrix for the searching range of coeffients in stage two.
The coefficient taking value of positive/negative one should not be included.}

\item{cluster}{default is FALSE, meaning do not use parallel computing for the genetic algorithm(GA).}

\item{p_level}{choose between 0,1,2,3 to indicate different levels of output
from the genetic function. Specifically, 0 (minimal printing),
  1 (normal), 2 (detailed), and 3 (debug).}

\item{pop.size}{an integer with the default set to be 3000. This is roughly the 
number individuals for the first generation
in the genetic algorithm (\code{rgenoud::genoud}).}
}
\description{
This function inplements the estimator of
two-stage quantile-optimal treatment regime with censored outcome 
by inverse probability of weighting, which is proposed in Chapter 3 of
\insertCite{zhou2018quantile}{QTOCen}.
We assume the censoring is independent of everything else, including the treatment
covariates, and potential outcomes.

Specifically, we do grid search on the sign of the coefficient for the first non-intercept variables
 in stage 1 and stage 2 and apply genetic algorithm on the remaining coeffients simultaneously.
 So if stage one has d1 covariates excluding the intercept, stage two has d2, the
 resulting coefficient has dimension d1+d2+2.
}
\details{
In our setting, if a subject was censored or had experienced the event of interest
before \code{s_Diff_Time} units of time had elapsed after the first stage of treatment,
s/he would not be eligible to receive a second stage treatment.
}
\examples{
\donttest{
D <- simJLSDdata(400, case="a")
fit_2stage <-IPWE_Qopt_DTR_IndCen(data=D, tau= 0.3, regimeClass.stg1 = a0~x0,
                     regimeClass.stg2 = a1~x1,
                     sign_beta1.stg1 = FALSE,
                     sign_beta1.stg2 = FALSE)
}

\dontshow{
D <- simJLSDdata(100, case="a")
fit_2stage <-IPWE_Qopt_DTR_IndCen(data=D, tau= 0.3, regimeClass.stg1 = a0~x0,
                     regimeClass.stg2 = a1~x1,
                     sign_beta1.stg1 = FALSE,
                     sign_beta1.stg2 = FALSE,
                     s.tol = 0.1, it.num=2, pop.size=1000)
}

}
\references{
\insertRef{zhou2018quantile}{QTOCen}
}
\author{
Yu Zhou, \email{zhou0269@umn.edu}
}
