% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimSplit_dichotom.R
\name{optimSplit_dichotom}
\alias{optimSplit_dichotom}
\alias{split_dichotom}
\alias{splits_dichotom}
\alias{quantile.splits_dichotom}
\title{Optimal Dichotomizing Predictors via Repeated Sample Splits}
\usage{
optimSplit_dichotom(
  formula,
  data,
  include = quote(p1 > 0.15 & p1 < 0.85),
  top = 1L,
  nsplit,
  ...
)

split_dichotom(y, x, id, ...)

splits_dichotom(y, x, ids = rSplit(y, ...), ...)

\method{quantile}{splits_dichotom}(x, probs = 0.5, ...)
}
\arguments{
\item{formula, y, x}{\link[stats]{formula}, e.g., \code{y~X} or \code{y~x1+x2}.
Response \eqn{y} may be \link[base]{double}, \link[base]{logical} and \link[survival]{Surv}.
Candidate \link[base]{numeric} predictors \eqn{x}'s may be specified as the columns of one \link[base]{matrix} column, e.g., \code{y~X}; or as several \link[base]{vector} columns, e.g., \code{y~x1+x2}.
In helper functions, \code{x} is a \link[base]{numeric} \link[base]{vector}.}

\item{data}{\link[base]{data.frame}}

\item{include}{(optional) \link[base]{language}, inclusion criteria.
Default \code{(p1>.15 & p1<.85)} specifies a user-desired range of \eqn{p_1}
for the candidate dichotomizing predictors.
See explanation of \eqn{p_1} in section \strong{Returns of Helper Functions}.}

\item{top}{positive \link[base]{integer} scalar, number of optimal dichotomizing predictors, default \code{1L}}

\item{nsplit, ...}{additional parameters for function \link{rSplit}}

\item{id}{\link[base]{logical} \link[base]{vector} for helper function \link{split_dichotom}, indices of training (\code{TRUE}) and test (\code{FALSE}) subjects}

\item{ids}{(optional) \link[base]{list} of \link[base]{logical} \link[base]{vector}s for helper function \link{splits_dichotom}, multiple copies of indices of repeated training-test sample splits.}

\item{probs}{\link[base]{double} scalar for helper function \link{quantile.splits_dichotom}, see \link[stats]{quantile}}
}
\value{
Function \link{optimSplit_dichotom} returns an object of \link[base]{class} \code{'optimSplit_dichotom'}, which is a \link[base]{list} of dichotomizing \link[base]{function}s,
with the input \code{formula} and \code{data} as additional \link[base]{attributes}.
}
\description{
To identify the optimal dichotomizing predictors using repeated sample splits.
}
\details{
Function \link{optimSplit_dichotom} identifies the optimal dichotomizing predictors via repeated sample splits. Specifically,

\enumerate{
\item Generate multiple, i.e., repeated, training-test sample splits (via \link{rSplit})
\item For each candidate predictor \eqn{x_i}, find the \emph{\strong{median-split-dichotomized regression model}} based on the repeated sample splits, see details in section \strong{Details on Helper Functions}
\item Limit the selection of the candidate predictors \eqn{x}'s to a user-desired range of \eqn{p_1} of the split-dichotomized regression models, see explanations of \eqn{p_1} in section \strong{Returns of Helper Functions}
\item Rank the candidate predictors \eqn{x}'s by the decreasing order of the \link[base]{abs}olute values of the regression coefficient estimate of the median-split-dichotomized regression models.  On the top of this rank are the \emph{\strong{optimal dichotomizing predictors}}.
}
}
\section{Details on Helper Functions}{

\subsection{Split-Dichotomized Regression Model}{

Helper function \link{split_dichotom} performs a univariable regression model on the test set with a dichotomized predictor, using a dichotomizing rule determined by a recursive partitioning of the training set.
Specifically, given a training-test sample split,
\enumerate{
\item find the \emph{dichotomizing rule} \eqn{\mathcal{D}} of the predictor \eqn{x_0} given the response \eqn{y_0} in the training set (via \link{rpartD});
\item fit a univariable regression model of the response \eqn{y_1} with the dichotomized predictor \eqn{\mathcal{D}(x_1)} in the test set.
}
Currently the Cox proportional hazards (\link[survival]{coxph}) regression for \link[survival]{Surv} response, logistic (\link[stats]{glm}) regression for \link[base]{logical} response and linear (\link[stats]{lm}) regression for \link[stats]{gaussian} response are supported.
}


\subsection{Split-Dichotomized Regression Models based on Repeated Training-Test Sample Splits}{

Helper function \link{splits_dichotom} fits multiple split-dichotomized regression models \link{split_dichotom} on the response \eqn{y} and predictor \eqn{x}, based on each copy of the repeated training-test sample splits.
}


\subsection{Quantile of Split-Dichotomized Regression Models}{

Helper function \link{quantile.splits_dichotom} is a method dispatch of the S3 generic function \link[stats]{quantile} on \link{splits_dichotom} object.
Specifically,

\enumerate{
\item {collect the univariable regression coefficient estimate from each one of the split-dichotomized regression models;}
\item {find the nearest-even (i.e., \code{type = 3}) \link[stats]{quantile} of the coefficients from Step 1. By default, we use the \link[stats]{median} (i.e., \code{prob = .5});}
\item {the split-dichotomized regression model corresponding to the selected coefficient quantile in Step 2, is returned.}
}
}
}

\section{Returns of Helper Functions}{


Helper function \link{split_dichotom} returns a split-dichotomized regression model, which is either a Cox proportional hazards (\link[survival]{coxph}), a logistic (\link[stats]{glm}), or a linear (\link[stats]{lm}) regression model, with additional \link[base]{attributes}

\describe{
\item{\code{attr(,'rule')}}{\link[base]{function}, dichotomizing rule \eqn{\mathcal{D}} based on the training set}
\item{\code{attr(,'text')}}{\link[base]{character} scalar, human-friendly description of \eqn{\mathcal{D}}}
\item{\code{attr(,'p1')}}{\link[base]{double} scalar, \eqn{p_1 = \text{Pr}(\mathcal{D}(x_1)=1)}}
\item{\code{attr(,'coef')}}{\link[base]{double} scalar, univariable regression coefficient estimate of \eqn{y_1\sim\mathcal{D}(x_1)}}
}



Helper function \link{splits_dichotom} returns a \link[base]{list} of split-dichotomized regression models (\link{split_dichotom}).


Helper function \link{quantile.splits_dichotom} returns a split-dichotomized regression model (\link{split_dichotom}).
}

\examples{
# see ?`Qindex-package`
}
