% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simil_Frechet_metric.R
\name{simil_Frechet_metric}
\alias{simil_Frechet_metric}
\title{Similarity metric using Fréchet distance}
\usage{
simil_Frechet_metric(data, test = FALSE, sim = NULL, superposition = "None")
}
\arguments{
\item{data}{A \code{track} R object, which is a list consisting of two elements:
\itemize{
\item \strong{\code{Trajectories}}: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
\item \strong{\code{Footprints}}: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
}}

\item{test}{Logical; if \code{TRUE}, the function compares the observed Fréchet distances against
simulated trajectories and calculates \emph{p}-values. Default is \code{FALSE}.}

\item{sim}{A \code{track simulation} R object consisting of a list of simulated trajectories to use for comparison when \code{test = TRUE}.}

\item{superposition}{A character string indicating the method used to align trajectories.
Options are \code{"None"}, \code{"Centroid"}, or \code{"Origin"}. Default is \code{"None"}.}
}
\value{
A \code{track similarity} R object consisting ofa list containing the following elements:
\item{Frechet_distance_metric}{A matrix containing the pairwise Frechet distances between trajectories.}
\item{Frechet_distance_metric_p_values}{(If \code{test} is \code{TRUE)} A matrix containing the \emph{p}-values for the pairwise Frechet distances.}
\item{Frechet_metric_p_values_combined}{(If \code{test} is \code{TRUE)} The overall \emph{p}-value for the combined Frechet distances.}
\item{Frechet_distance_metric_simulations}{(If \code{test} is \code{TRUE)} A list of Frechet distance matrices from each simulated dataset.}
}
\description{
\code{simil_Frechet_metric()} computes similarity metrics between two or more trajectories using
the Fréchet distance. It allows for different superposition methods
to align trajectories before calculating the Fréchet distance  metrics. The function also supports
testing with simulations to calculate \emph{p}-values for the Fréchet distance metrics.
}
\details{
The \code{simil_Frechet_metric()} function calculates the similarity between trajectories using
the \code{Frechet()} function from the \pkg{SimilarityMeasures} package.

The Fréchet distance is a measure of similarity between two curves or continuous trajectories, which takes into account
both the order and location of points within the trajectories (Besse et al. 2015). The distance can be described by the
analogy of a person walking a dog on an extendable leash (Aronov et al. 2006). Both the person and the dog move along
their respective trajectories, with each able to adjust their speed but not retrace their steps. The Fréchet distance is
the minimum leash length required to keep the dog connected to the person throughout the walk (Cleasby et al., 2019).

Unlike other trajectory comparison techniques, such as Dynamic Time Warping, the Fréchet distance focuses on the overall
shape of the trajectories rather than matching specific points. As a result, it is sensitive to noise because all points
of the compared trajectories are considered in its calculation. However, it can still be a powerful tool for trajectory
clustering and comparison, particularly when shape is the primary concern (Cleasby et al., 2019).

Note that when comparing real trajectories that are very disparate or those simulated under an unconstrained method,
the resulting trajectories may not be suitable for Fréchet distance calculations. In such cases, the Fréchet distance is
returned as -1 to indicate an invalid measurement.

The function offers three different superposition methods to align the trajectories
before \code{Frechet()} is applied:
\itemize{
\item \code{"None"}: No superposition is applied.
\item \code{"Centroid"}: Trajectories are shifted to align based on their centroids.
\item \code{"Origin"}: Trajectories are shifted to align based on their starting point.
}

If \code{test = TRUE}, the function can compute \emph{p}-values by comparing the observed Fréchet
distances with those generated from a set of simulated trajectories. The \emph{p}-values
are calculated for both individual trajectory pairs and for the entire set of trajectories.
}
\section{Logo}{

\if{html}{\figure{Logo.png}{options: width=30\%}}
}

\examples{
# Example 1: Simulating tracks using the "Directed" model and comparing Frechet distance
# in the PaluxyRiver dataset
s1 <- simulate_track(PaluxyRiver, nsim = 3, model = "Directed")
simil_Frechet_metric(PaluxyRiver, test = TRUE, sim = s1, superposition = "None")

# Example 2: Simulating tracks using the "Constrained" model and comparing Frechet distance
# in the PaluxyRiver dataset  using the "Centroid" superposition method
s2 <- simulate_track(PaluxyRiver, nsim = 3, model = "Constrained")
simil_Frechet_metric(PaluxyRiver, test = TRUE, sim = s2, superposition = "Centroid")

# Example 3: Simulating tracks using the "Unconstrained" model and comparing Frechet distance
# in the PaluxyRiver dataset using the "Origin" superposition method
s3 <- simulate_track(PaluxyRiver, nsim = 3, model = "Unconstrained")
simil_Frechet_metric(PaluxyRiver, test = TRUE, sim = s3, superposition = "Origin")


}
\references{
Cleasby, I. R., Wakefield, E. D., Morrissey, B. J., Bodey, T. W., Votier, S. C., Bearhop, S., & Hamer, K. C. (2019). Using time-series similarity measures to compare animal movement trajectories in ecology. Behavioral Ecology and Sociobiology, 73, 1-19.
}
\seealso{
\code{\link{tps_to_track}}, \code{\link{simulate_track}}, \code{\link[SimilarityMeasures]{Frechet}}
}
\author{
Humberto G. Ferrón

humberto.ferron@uv.es

Macroevolution and Functional Morphology Research Group (www.macrofun.es)

Cavanilles Institute of Biodiversity and Evolutionary Biology

Calle Catedrático José Beltrán Martínez, nº 2

46980 Paterna - Valencia - Spain

Phone: +34 (9635) 44477
}
