% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.clean.R
\name{q.clean}
\alias{q.clean}
\title{Clean data by eliminating genes with many missing values}
\usage{
q.clean(x, missing = 0.1, lowest = 10)
}
\arguments{
\item{x}{A data matrix (raw: samples, col: genes).}

\item{missing}{A ratio of missing values in each column allowed to be remained in the data.}

\item{lowest}{The lowest value recognized in the data (e.g., TPM, FPKM, or raw read counts).}
}
\value{
A data matrix (raw: samples, col: qualified genes)
}
\description{
Clean data by eliminating genes with many missing values
}
\examples{
data(Pinus)
train.raw <- Pinus$train
ncol(train.raw)

train <- q.clean(train.raw)
ncol(train)
}
\author{
Takahiko Koizumi
}
