% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.pca.R
\name{q.pca}
\alias{q.pca}
\title{Visualize gene expression similarity using principal coordinate analysis}
\usage{
q.pca(x, y, method = "linear", lower.thr = 0, n.gene = ncol(x), size = 1)
}
\arguments{
\item{x}{A data matrix (row: samples, col: genes).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{lower.thr}{The lower threshold of R-squared value to be indicated in a PCA plot (default: 0).}

\item{n.gene}{The number of candidate genes for QuEST model to be indicated in a PCA plot (default: ncol(x)).}

\item{size}{The size of symbols in a PCA plot (default: 1).}
}
\value{
A PCA plot
}
\description{
Visualize gene expression similarity using principal coordinate analysis
}
\examples{
data(Pinus)
train <- q.clean(Pinus$train)
target <- Pinus$target
q.pca(train, target)
}
\author{
Takahiko Koizumi
}
