% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.rank.R
\name{q.rank}
\alias{q.rank}
\title{Visualize R-squared value distribution in gene-environment interaction}
\usage{
q.rank(
  x,
  y,
  method = "linear",
  lower.thr = 0,
  n.gene = ncol(x),
  upper.xlim = ncol(x)
)
}
\arguments{
\item{x}{A data matrix (row: samples, col: genes).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{lower.thr}{The lower threshold of R-squared value to be included in QuEST model (default: 0).}

\item{n.gene}{The number of genes to be included in QuEST model (default: ncol(x)).}

\item{upper.xlim}{The upper limitation of x axis (i.e., the number of genes) in the resulted figure (default: ncol(x)).}
}
\value{
A rank order plot
}
\description{
Visualize R-squared value distribution in gene-environment interaction
}
\examples{
data(Pinus)
train <- q.clean(Pinus$train)
target <- Pinus$target
train <- q.sort(train, target)
q.rank(train, target)
}
\author{
Takahiko Koizumi
}
