% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BulkProcessing.R
\name{BulkProcessing}
\alias{BulkProcessing}
\title{Processing and analyzing Multiple Experiments}
\usage{
BulkProcessing(data, do_analysis = TRUE, params = list(), verbose = FALSE)
}
\arguments{
\item{data}{Compiled data of experiments.}

\item{do_analysis}{Logical. Whether statistic analysis is included. Default is \code{TRUE}.}

\item{params}{A list of parameters for various processing steps. If a parameter is not
provided, default values will be used. \code{control} used in \code{GetAnalysis()} is required.
parameters can be provided for the following functions:
\itemize{
\item \code{ConvertTime}
\item \code{CleanMeta}
\item \code{CleanRaw}
\item \code{GetCalculation}
\item \code{SpreadCalculation}
\item \code{GetAnalysis}
\item \code{SummarizeResult}
}}

\item{verbose}{Logical; if TRUE, prints detailed processing information for troubleshooting.
Default is FALSE.}
}
\value{
A list containing three elements:
\itemize{
\item combined_calculation: A data frame of combined calculations from all experiments
\item combined_cleanraw: Cleaned raw data for each experiment
\item combined_result: A data frame of combined results from all experiments
}
}
\description{
This function processes multiple experiments in parallel, performing a series of operations
including time conversion, metadata cleaning, raw data cleaning, calculations, analysis,
and result summarization.
}
\examples{
#Get path for example data
path = system.file("extdata", package = "QuICSeedR")

#Helper function
add_underscore <- function(text) {
  gsub("([a-zA-Z])(\\\\d)", "\\\\1_\\\\2", text)
  }
  
#Read in data
elkear = BulkReadMARS(path = path, 
                      plate_subfix = 'plate',
                      raw_subfix = 'raw', 
                      helper_func = add_underscore)
                      
#Set up parameters for batch analysis
params = list(
  CleanMeta = list(split_content = TRUE, split_into = c('region', 'sample')),
  GetCalculation = list(cycle_background = 5, norm = TRUE, norm_ct = 'Pos',
                       sd_fold = 10, time_skip = 5),
  GetAnalysis = list(control = "Neg")
  )
  
#Get results     
results = BulkProcessing(data =elkear, params = params)

str(results)


}
