% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareQuartets.R
\name{AllQuartets}
\alias{AllQuartets}
\alias{AllQuartets.numeric}
\alias{AllQuartets.phylo}
\title{List all quartets}
\usage{
AllQuartets(nTips)

\method{AllQuartets}{numeric}(nTips)

\method{AllQuartets}{phylo}(nTips)
}
\arguments{
\item{nTips}{Integer, specifying the number of tips in a tree; or a tree,
whose tips will be counted.}
}
\value{
\code{AllQuartets()} returns a matrix with four rows and
\code{choose(n_tips, 4)} columns, with each column corresponding to a unique
selection of four different integers less than or equal to \code{nTips}.
}
\description{
Lists all choices of four taxa from a tree.

A more computationally efficient alternative to \code{\link[utils]{combn}}.
}
\examples{
AllQuartets(5)
 
combn(5, 4) # Provides the same information, but for large 
            # values of n_tips is significantly slower.

}
\seealso{
States of quartets in given trees: \code{\link[=QuartetStates]{QuartetStates()}}

Other quartet counting functions: 
\code{\link{CompareQuartets}()},
\code{\link{CompareQuartetsMulti}()},
\code{\link{ResolvedQuartets}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{quartet counting functions}
