% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R.from.r.R
\name{R.from.r}
\alias{R.from.r}
\title{Estimate reproduction number from exponential growth rate}
\usage{
R.from.r(r, GT)
}
\arguments{
\item{r}{The exponential growth rate.}

\item{GT}{Generation time distribution from \code{\link[=generation.time]{generation.time()}}.}
}
\value{
A numeric value for R.
}
\description{
Calculates the basic reproduction number \eqn{R_{0}} from the exponential
growth rate obtained by either Poisson or log-linear regression.
}
\details{
For internal use. Called by \code{\link[=est.R0.EG]{est.R0.EG()}}.

\eqn{R_{0}} is calculated as the inverse of the discretized Laplace transform,
making use of the discretized generation time distirbution (output from
\code{\link[=generation.time]{generation.time()}}).
}
\note{
The formula for the discretized Laplace transform is taken from
Wallinga & Lipsitch (2007).
}
\references{
Wallinga, J., and M. Lipsitch. "How Generation Intervals Shape the Relationship Between Growth Rates and Reproductive Numbers." Proceedings of the Royal Society B: Biological Sciences 274, no. 1609 (2007): 599.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
