% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R0.sR.R
\name{plot.R0.sR}
\alias{plot.R0.sR}
\title{Plot the R0/Rt value along with confidence interval}
\usage{
\method{plot}{R0.sR}(x, xscale = "w", TD.split = FALSE, ...)
}
\arguments{
\item{x}{An output of \code{\link[=estimate.R]{estimate.R()}} (class \code{R0.sR})}

\item{xscale}{Scale to be adjusted on x-axis. Can be \code{d} (day), \code{w} (week (default)), \code{f} (fornight), \code{m} (month).}

\item{TD.split}{Boolean. Parameter to force the display of both \eqn{R(t)} and the epidemic curve in the same window for the TD method.}

\item{...}{Parameters passed to inner functions.}
}
\value{
This function does not return any data.
Called for side effect. Draws all \eqn{R_{0}} or /eqn{R(t)} values from an
output of \code{\link[=estimate.R]{estimate.R()}}, built with one or more methods.
}
\description{
Generates the graphical output for estimated \eqn{R} or \eqn{R(t)} fits.
}
\details{
For internal use. Called by [base::plot())].

Tweaked [base::plot()] function that draws the reproduction number values
for each method contained in the object constructed by [estimate.R()].

[base::plot())]: R:base::plot())
[base::plot()]: R:base::plot()
[estimate.R()]: R:estimate.R()
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
