% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.GT.R
\name{sa.GT}
\alias{sa.GT}
\title{Sensitivity of R0 to varying generation time distributions}
\usage{
sa.GT(
  incid,
  GT.type,
  GT.mean.range,
  GT.sd.range,
  begin = NULL,
  end = NULL,
  est.method,
  t = NULL,
  date.first.obs = NULL,
  time.step = 1,
  ...
)
}
\arguments{
\item{incid}{A vector of incident cases.}

\item{GT.type}{Type of distribution for GT (see GT.R for details).}

\item{GT.mean.range}{Range of mean values used for all GT distributions throughout the simulation. Must be provided as a vector.}

\item{GT.sd.range}{Range of standard deviation values used for GT distributions. Must be provided as a vector.}

\item{begin}{Vector of begin dates for the estimation of epidemic.}

\item{end}{Vector of end dates for estimation of the epidemic.}

\item{est.method}{Estimation method used for sensitivity analysis.}

\item{t}{Dates vector to be passed to estimation function.}

\item{date.first.obs}{Optional date of first observation, if t not specified.}

\item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation.}

\item{...}{Parameters passed to inner functions}
}
\value{
A data.frame \code{s.a} with following components :
\item{GT.type}{Type of distribution for GT.}
\item{GT.mean}{Range of means used for tested GTs.}
\item{GT.sd}{Range of standard deviations used for tested GTs.}
\item{R}{Computed value for Reproduction Number given GT.type, GT.mean and GT.sd.}
\item{CI.lowe}{The lower limit of 95\% CI for R.}
\item{CI.upper}{The upper limit of 95\% CI for R.}
}
\description{
Sensitivity analysis to estimate the variation of reproduction numbers
according to the disitrbution of generation time.
}
\details{
By using different Generation Time (GT) distribution, different estimates of
the reproduction ratio can be analyzed.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
