% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_RPTW.r
\name{sim_RPTW}
\alias{sim_RPTW}
\title{Simulate a Trial Using Randomized Play-the-Winner Rule for Binary Endpoint}
\usage{
sim_RPTW(
  Pats,
  nMax,
  TimeToOutcome,
  enrollrate,
  na0,
  nb0,
  na1,
  nb1,
  h,
  alphaa = 0.025,
  N2,
  side,
  Z = NULL
)
}
\arguments{
\item{Pats}{the number of patients accrued within a certain time frame indicates the
count of individuals who have been affected by the disease during that specific period,
for example, a month or a day. If this number is 10, it represents that
10 people have got the disease within the specified time frame.}

\item{nMax}{the assumed maximum accrued number of patients with the disease in the population, this number
should be chosen carefully to ensure a sufficient number of patients are simulated,
especially when considering the delay mechanism.}

\item{TimeToOutcome}{the distribution of delayed response times or a fixed delay time for responses.
The delayed time could be a month, a week or any other time frame. When the unit changes,
the number of TimeToOutcome should also change. It can be in the format
of expression(rnorm( length( vStartTime ),30, 3)), representing delayed responses
with a normal distribution, where the mean is 30 days and the standard deviation is 3 days.}

\item{enrollrate}{probability that patients in the population can enroll in the trial.
This parameter is related to the number of people who have been affected by the disease in the population,
following an exponential distribution.}

\item{na0, nb0}{the initial number of balls in the urn represents the control group and the treatment group.}

\item{na1, nb1}{additional number of balls represents the control group and the treatment group added to 
the urn after the result of each participant.}

\item{h}{a vector of hypothesis, for example, as c(0.1,0.1) where 0.1 stands for the success probability
for both groups. Another example is c(0.1,0.3) where 0.1 and 0.3 stand for the success probabilities
for the control and a treatment group, respectively.}

\item{alphaa}{the overall type I error to be controlled for the one-sided test. Default value is set to 0.025.}

\item{N2}{maximal sample size for the trial.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{Z}{the selected cut-off value. Only specified Z when the cut-off value is selected by simulations.}
}
\value{
\code{sim_RPTW} returns an object of class "rptw". An object of class "rptw" is a list containing 
final decision based on the Z test statistics with 1 stands for selected and 0 stands for not selected, 
Z test statistics, the simulated data set and participants accrued for each arm at the time of termination
of that group in one trial.
The simulated data set includes 5 columns: participant ID number, enrollment time, observed time of results,
allocated arm, and participants' result with 1 stand for selected and 0 stand for not selected.
}
\description{
Simulate randomized play-the-winner rule in a two-armed trial with binary endpoint.
}
\details{
This function simulates trials using the randomized play-the-winner
rule under both no delay and delayed scenarios. This method is a type of urn design 
with the motivation to allocate more participants to the better treatment group.
Considering the delay mechanism, \code{Pats} (the number of patients accrued within a certain time frame),
\code{nMax} (the assumed maximum accrued number of patients with the disease in the population) and 
\code{TimeToOutcome} (the distribution of delayed response times or a fixed delay time for responses) 
are parameters in the functions adapted from \url{https://github.com/kwathen/IntroBayesianSimulation}.
Refer to the website for more details.
}
\examples{
#sim_RPTW with no delay responses
sim_RPTW(Pats=10,nMax=50000,TimeToOutcome=0,enrollrate=0.9,na0=1,nb0=1,na1=1,nb1=1,
h=c(0.1,0.3),alphaa=0.025,N2=168,side='upper')
#sim_RPTW with delayed responses follow a normal distribution with
#a mean of 30 days and a standard deviation of 3 days
sim_RPTW(Pats=10,nMax=50000,TimeToOutcome=expression(rnorm( length( vStartTime ),30, 3)),
enrollrate=0.9,na0=1,nb0=1,na1=1,nb1=1,h=c(0.1,0.3),alphaa=0.025,N2=168,side='upper')
}
\references{
\insertRef{Wei1978}{RARtrials}
}
