% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_brar_binary.r
\name{sim_brar_binary}
\alias{sim_brar_binary}
\title{Simulate a Trial Using Bayesian Response-Adaptive Randomization with a Control Group for Binary Outcomes}
\usage{
sim_brar_binary(
  Pats,
  nMax,
  TimeToOutcome,
  enrollrate,
  N1,
  armn,
  h,
  au,
  N2,
  tp,
  armlabel,
  blocksize,
  alpha1 = 1,
  beta1 = 1,
  alpha2 = alpha1,
  beta2 = beta1,
  alpha3 = alpha1,
  beta3 = beta1,
  alpha4 = alpha1,
  beta4 = beta1,
  alpha5 = alpha1,
  beta5 = beta1,
  minstart,
  deltaa,
  tpp = 0,
  deltaa1,
  side,
  ...
)
}
\arguments{
\item{Pats}{the number of patients accrued within a certain time frame indicates the
count of individuals who have been affected by the disease during that specific period,
for example, a month or a day. If this number is 10, it represents that
10 people have got the disease within the specified time frame.}

\item{nMax}{the assumed maximum accrued number of patients with the disease in the population, this number
should be chosen carefully to ensure a sufficient number of patients are simulated,
especially when considering the delay mechanism.}

\item{TimeToOutcome}{the distribution of delayed response times or a fixed delay time for responses.
The delayed time could be a month, a week or any other time frame. When the unit changes,
the number of TimeToOutcome should also change. It can be in the format
of expression(rnorm( length( vStartTime ),30, 3)), representing delayed responses
with a normal distribution, where the mean is 30 days and the standard deviation is 3 days.}

\item{enrollrate}{probability that patients in the population can enroll in the trial.
This parameter is related to the number of people who have been affected by the disease in the population,
following an exponential distribution.}

\item{N1}{number of participants with equal randomization in the 'initialization' period.
Recommend using 10 percent of the total sample size.}

\item{armn}{number of total arms in the trial.}

\item{h}{a vector of success probabilities in hypotheses, for example, as c(0.1,0.1) where 0.1 stands for the success probability
for both groups. Another example is c(0.1,0.3) where 0.1 and 0.3 stand for the success probabilities
for the control and the treatment group, respectively.}

\item{au}{a vector of cut-off values in the final selection at the end of the trial,
with a length equal to the number of arms minus 1.}

\item{N2}{maximal sample size for the trial.}

\item{tp}{tuning parameter. Some commonly used numbers are 0.5, 1 and n/2N.}

\item{armlabel}{a vector of arm labels with an example of c(1, 2), where 1 and 2 describe
how each arm is labeled in a two-armed trial.}

\item{blocksize}{size of block used for equal randomization regarding participants in the 'initialization' period.
Recommend to be an even multiple of the number of total arms.}

\item{alpha1, beta1}{\eqn{\alpha} and \eqn{\beta} in the \eqn{Beta(\alpha,\beta)}, prior for arm 1 which
stands for the control. Default value is set to 1.}

\item{alpha2, beta2}{\eqn{\alpha} and \eqn{\beta} in the \eqn{Beta(\alpha,\beta)}, prior for arm 2.
Default value is set to \code{alpha1} and \code{beta1}.}

\item{alpha3, beta3}{\eqn{\alpha} and \eqn{\beta} in the \eqn{Beta(\alpha,\beta)} prior for arm 3.
Default value is set to \code{alpha1} and \code{beta1}.}

\item{alpha4, beta4}{\eqn{\alpha} and \eqn{\beta} in the \eqn{Beta(\alpha,\beta)} prior for arm 4.
Default value is set to \code{alpha1} and \code{beta1}..}

\item{alpha5, beta5}{\eqn{\alpha} and \eqn{\beta} in the \eqn{Beta(\alpha,\beta)} prior for arm 5.
Default value is set to \code{alpha1} and \code{beta1}.}

\item{minstart}{a specified number of participants when one starts to check decision rules.}

\item{deltaa}{a vector of minimal effect expected to be observed for early futility stopping in
each arm is approximately \eqn{1\%}. The length of this parameter is \code{armn}-1.}

\item{tpp}{indicator of \code{tp} equals to n/2N. When \code{tp} is n/2N, \code{tpp} should be assigned 1. Default value is set to 0.}

\item{deltaa1}{a vector of pre-specified minimal effect size expected to be observed at the final stage
for each arm. The length of this parameter is \code{armn}-1.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{...}{additional arguments to be passed to \code{\link[stats]{integrate}} (such as rel.tol) from this function.}
}
\value{
\code{sim_brar_binary} returns an object of class "brar". An object of class "brar" is a list containing 
final decision, test statistics, the simulated data set and participants accrued for each arm 
at the time of termination of that group in one trial.
The simulated data set includes 5 columns: participant ID number, enrollment time, observed time of results,
allocated arm, and participants' results. In the final decision, 'Superiorityfinal' refers to the selected arm, 
while 'Not Selected' indicates the arm stopped due to futility, and 'Control Selected' denotes the control arm chosen 
because other arms did not meet futility criteria before the final stage or were not deemed effective at the final stage. 
Note that before final stage of the trial, test statistics is calculated from \code{deltaa}, and test statistics is
calculated from \code{deltaa1} at the final stage.
}
\description{
\code{sim_brar_binary} simulate a trial with two to five arms using Bayesian Response-Adaptive 
Randomization with a control group for binary outcomes. The conjugate prior distributions follow Beta
(\eqn{Beta(\alpha,\beta)}) distributions and can be specified individually for each arm.
}
\details{
This function generates a designed trial using Bayesian response-adaptive randomization with
a control group under no delay and delayed scenarios for binary outcomes. The function can handle trials with up to
5 arms. This function uses the formula
\eqn{\frac{Pr(p_k={\sf max}\{p_1,...,p_K\})^{tp}} {\sum_{k=1}^{K}{Pr(p_k={\sf max}\{p_1,...,p_K\})^{tp}}}} with \code{side} equals to 'upper',
and \eqn{\frac{Pr(p_k={\sf min}\{p_1,...,p_K\})^{tp}} {\sum_{k=1}^{K}{Pr(p_k={\sf min}\{p_1,...,p_K\}){tp}}}} 
with \code{side} equals to 'lower', utilizing available data at each step.
Considering the delay mechanism, \code{Pats} (the number of patients accrued within a certain time frame),
\code{nMax} (the assumed maximum accrued number of patients with the disease in the population) and 
\code{TimeToOutcome} (the distribution of delayed response times or a fixed delay time for responses) 
are parameters in the functions adapted from \url{https://github.com/kwathen/IntroBayesianSimulation}.
Refer to the website for more details.
}
\examples{
#sim_brar_binary with delayed responses follow a normal distribution with a mean
#of 30 days and a standard deviation of 3 days, where h1=c(0.2,0.4) and tp=0.5.
sim_brar_binary(Pats=10,nMax=50000,TimeToOutcome=expression(rnorm( length( vStartTime ),30, 3)),
enrollrate=0.1,N1=24,armn=2,h=c(0.2,0.4),au=0.36,N2=224,tp=0.5,armlabel=c(1,2),blocksize=4,
alpha1=1,beta1=1,alpha2=1,beta2=1,minstart=24,deltaa=-0.01,tpp=0,deltaa1=0.1,side='upper')
}
\references{
\insertRef{Wathen2017}{RARtrials}
}
