% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBesT-package.R
\docType{package}
\name{RBesT-package}
\alias{RBesT}
\alias{RBesT-package}
\title{R Bayesian Evidence Synthesis Tools}
\description{
The RBesT tools are designed to support in the derivation of
parametric informative priors, asses design characeristics and
perform analyses. Supported endpoints include normal, binary and
Poisson.
}
\details{
For introductory material, please refer to the vignettes which include

\itemize{
\item Introduction (binary)
\item Introduction (normal)
\item Customizing RBesT Plots
\item Robust MAP, advanced usage
}

The main function of the package is \code{\link[=gMAP]{gMAP()}}. See it's
help page for a detailed description of the statistical model.
}
\section{Global Options}{


\tabular{lcl}{
Option \tab Default \tab Description \cr
\code{RBesT.MC.warmup} \tab 2000 \tab MCMC warmup iterations \cr
\code{RBesT.MC.iter} \tab 6000 \tab total MCMC iterations \cr
\code{RBesT.MC.chains} \tab 4 \tab MCMC chains\cr
\code{RBesT.MC.thin} \tab 4 \tab MCMC thinning \cr
\code{RBesT.MC.control} \tab \verb{list(adapt_delta=0.99,} \tab sets \code{control} argument for Stan call\cr
\tab \verb{stepsize=0.01,} \tab \cr
\tab \verb{max_treedepth=20)} \tab \cr
\code{RBesT.MC.ncp} \tab 1 \tab parametrization: 0=CP, 1=NCP, 2=Automatic  \cr
\code{RBesT.MC.init} \tab 1 \tab range of initial uniform \eqn{[-1,1]} is the default  \cr
\code{RBesT.MC.rescale} \tab \code{TRUE} \tab Automatic rescaling of raw parameters  \cr
\code{RBesT.verbose} \tab \code{FALSE} \tab requests outputs to be more verbose\cr
\code{RBesT.integrate_args} \tab \verb{list(lower=-Inf,} \tab arguments passed to \code{integrate} for\cr
\tab \verb{upper=Inf,} \tab intergation of densities\cr
\tab \verb{rel.tol=.Machine$double.eps^0.25,} \tab \cr
\tab \verb{abs.tol=.Machine$double.eps^0.25,} \tab \cr
\tab \verb{subdivisions=1E3)} \tab \cr
\code{RBesT.integrate_prob_eps} \tab \code{1E-6} \tab probability mass left out from tails if integration needs to be restricted in range \cr
}
}

\section{Version History}{


See \code{NEWS.md} file.
}

\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.19.3. https://mc-stan.org
}
\seealso{
Useful links:
\itemize{
  \item \url{https://opensource.nibr.com/RBesT/}
  \item Report bugs at \url{https://github.com/Novartis/RBesT/issues}
}

}
\author{
\strong{Maintainer}: Sebastian Weber \email{sebastian.weber@novartis.com}

Other contributors:
\itemize{
  \item Novartis Pharma AG [copyright holder]
  \item Beat Neuenschwander \email{beat.neuenschwander@novartis.com} [contributor]
  \item Heinz Schmidli \email{heinz.schmidli@novartis.com} [contributor]
  \item Baldur Magnusson \email{baldur.magnusson@novartis.com} [contributor]
  \item Yue Li \email{yue-1.li@novartis.com} [contributor]
  \item Satrajit Roychoudhury \email{satrajit.roychoudhury@novartis.com} [contributor]
  \item Lukas A. Widmer \email{lukas_andreas.widmer@novartis.com} (\href{https://orcid.org/0000-0003-1471-3493}{ORCID}) [contributor]
  \item Trustees of Columbia University (R/stanmodels.R, configure, configure.win) [copyright holder]
}

}
