% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhasePlot}
\alias{MultiPhasePlot}
\title{ Plot of the marginal posterior densities of several phases}
\usage{
MultiPhasePlot(data, position_minimum, position_maximum = position_minimum+1,
level = 0.95,  title = "Phases marginal posterior densities")
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm }
  \item{position_minimum}{numeric vector containing the column number corresponding to the minimum of the dates included in each phase}
  \item{position_maximum}{numeric vector containing the column number corresponding to the maximum of the dates included in each phase. By default, position_maximum = position_minimum + 1. 
}
  \item{level}{probability corresponding to the level of confidence}
  \item{title}{title of the graph}
}
\description{
Draws a plot with the marginal posterior densities of the minimum and the maximum of the dates included in each phase. No temporal order between phases is required.
}
\value{
Draws a plot with the marginal posterior densities of the minimum and the maximum of the dates included in each phase and adds the time range of each phase.
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  
  # List of the name of the phases 
  names(Phases)
  
  # Stipulating position_maximum
  MultiPhasePlot(Phases, c(4,2), c(5,3), title = "Succession of phase 1 and phase 2")
  
  # In this case, equivalent to 
  MultiPhasePlot(Phases, c(4,2), title = "Succession of phase 1 and phase 2")

}
\keyword{ phase time range }
\keyword{ marginal posterior density }
