% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_heroes.R
\name{get_heroes}
\alias{get_heroes}
\title{Dota Heroes}
\usage{
get_heroes(dota_id = 570, language = "en", key = NULL)
}
\arguments{
\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
A data.frame of Dota2 Heroes.
}
\details{
A list will be returned that contains three elements. The content, the url and the response
received from the api.

The content element of the list contains a data.frame with all the heroes. Each row of the
data.frame is a hero and the following columns are included:

\itemize{
  \item \strong{name:} Hero's name.
  \item \strong{id:} Hero's ID.
  \item \strong{localized_name:} Name of the hero in-game.
}
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetHeroes}
}
\examples{
\dontrun{
get_heroes()
get_heroes(language = 'en', key = NULL)
get_heroes(language = 'en', key = 'xxxxxxxxxxx')
}

}

