% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scheduled_league_games.R
\name{get_scheduled_league_games}
\alias{get_scheduled_league_games}
\title{Scheduled League Games}
\usage{
get_scheduled_league_games(date_min = NULL, date_max = NULL, tz = "",
  dota_id = "570", language = "en", key = NULL)
}
\arguments{
\item{date_min}{(optional) A date of the format "yyyy-mm-dd HH:MM:SS". See examples for details.
Return games from this date onwards.}

\item{date_max}{(optional) A date of the format "yyyy-mm-dd HH:MM:SS". See examples for details.
Return games up to this date}

\item{tz}{A time zone specification if date_min and/or date_max are used. See
\link{as.POSIXct}. "" (default) is the current time zone and "GMT" is UTC.}

\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
A list of scheduled league matches.
}
\details{
A list will be returned that contains three elements. The content, the url and the
response received from the api.

The content element of the list contains a games list with information about the matches.
Each element of the games list is a game. Each game consists of (some) of
the following sections:

\itemize{
  \item \strong{league_id:} The unique league id.
  \item \strong{game_id:} A unique game id.
  \item \strong{teams:} A list of the participating teams.
  \item \strong{starttime:} Unix Timestamp of start time.
  \item \strong{comment:} Description of game.
  \item \strong{final:} Whether the game is a final or not.
}
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetScheduledLeagueGames}
}
\examples{
\dontrun{
get_scheduled_league_games()
get_scheduled_league_games(language = 'en', key = NULL)
get_scheduled_league_games(language = 'en', key = 'xxxxxxxxxxx')
get_scheduled_league_games(date_min = '2016-06-01 00:00:00',
                           date_max = '2016-09-07 00:00:00')
}

}

