% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimFPM.R
\name{optimFPM}
\alias{optimFPM}
\title{Optimization of Floating Percentile Model Parameters}
\usage{
optimFPM(
  data,
  paramList,
  FN_crit = seq(0.1, 0.9, by = 0.05),
  alpha.test = seq(0.05, 0.5, by = 0.05),
  which = c(1, 2, 3, 4),
  simplify = TRUE,
  plot = TRUE,
  colors = heat.colors(10),
  colsteps = 100,
  ...
)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}}

\item{FN_crit}{numeric vector over which to optimize false negative thresholds (default = \code{seq(0.1, 0.9, by = 0.05))}}

\item{alpha.test}{numeric vector of type-I error rate values over which to optimize (default = \code{seq(0.05, 0.5, by = 0.05))}}

\item{which}{numeric or character indicating which type of plot to generate (see Details; default = \code{c(1, 2)})}

\item{simplify}{logical; whether to generate simplified output (default = \code{TRUE})}

\item{plot}{logical; whether to generate a plot to visualize the opimization results}

\item{colors}{values recognizible as colors to be passed to \code{colorRampPalette} (via \code{colorGradient}) to generate a palette for plotting (default = \code{heat.colors(10)})}

\item{colsteps}{integer; number of discrete steps to interpolate colors in \code{colorGradient} (default = \code{100})}

\item{...}{additional argument passed to \code{FPM}, \code{chemSig}, \code{chemSigSelect}, and \code{colorGradient}}
}
\value{
data.frame of optimized \code{FN_crit} and/or \code{alpha.test} values
}
\description{
Calculate parameter inputs that optimize benchmark performance
}
\details{
\code{optimFPM} was designed to help optimize the predictive capacity of the benchmarks generated by \code{FPM}. The default input parameters to
\code{FPM} (i.e., \code{FN_crit = 0.2} and \code{alpha.test = 0.05}) are arbitrary, and optimization can help to objectively establish more accurate benchmarks.
Graphical output from \code{optimFPM} can also help users to understand the relationship(s) between benchmark accuracy/error, \code{FN_crit}, and \code{alpha.test}.

Default inputs for \code{FN_crit} and \code{alpha.test} were selected to represent a reasonable range of values to test. Testing over both ranges
will result in a two-way optimization, which can be computationally intensive. Alternatively, \code{optimFPM} can be run for one parameter at a time
by specifying a single value for \code{FN_crit} or \code{alpha.test}. Note that inputting single values for both \code{FN_crit} and \code{alpha.test} will generate unhelpful results.

Several metrics are used for optimization:
\enumerate{
\item Ratio of sensitivity/specificity ("sensSpecRatio"), calculated as the minimum of the two metrics divided by the maximum of the two. Therefore, this value will always be between 0 and 1, representing the balance between correct \code{Hit==TRUE} and \code{Hit==FALSE} predictions.
\item Overall reliability ("OR") (i.e., probability of correctly predicting \code{Hit} values)
\item Fowlkes-Mallows Index ("FM") - an average of metrics focusing on predicting \code{Hit==TRUE}
\item Matthew's Correlation Coefficient ("MCC") - a measure of the correspondence between the data and predictions analogous to a Pearson's correlation coefficient (but for binary data)
}

Graphical output will differ depending on whether or not a single value is input for \code{FN_crit} or \code{alpha.test}. Providing a single value for one
of the two arguments will generate a line graph, whereas providing longer vectors (i.e., length > 1) of inputs for both arguments will generate dot matrix plots using \code{colors} to generate
a color palette and \code{colsteps} to define the granularity of the color gradient with the palette. The order of \code{colors} will be plotted
from more optimal to less optimal; for example, the default of \code{heat.colors(10)} will show optimal colors as red and less optimal colors as yellower.
By default, multiple plots will be generated, however the \code{which} argument can control which plots are generated. Inputs
to \code{which} are, by default, \code{c(1, 2, 3, 4)} for the metrics noted above, and flexible character inputs also can be used to a degree.
Black squares indicate the optimal argument inputs; these values are also printed to the console and can be assigned to an object.
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
FN_seq <- seq(0.1, 0.3, 0.05)
alpha_seq <- seq(0.05, 0.2, 0.05)
optimFPM(h.tristate, paramList, FN_seq, 0.05)
optimFPM(h.tristate, paramList, 0.2, alpha_seq)
optimFPM(h.tristate, paramList, FN_seq, alpha_seq, which=2)
}
\seealso{
FPM, colorGradient, colorRampPalette
}
