% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator-architectures.R
\name{DCGAN_Generator}
\alias{DCGAN_Generator}
\title{DCGAN Generator}
\usage{
DCGAN_Generator(
  noise_dim = 100,
  number_channels = 3,
  ngf = 64,
  dropout_rate = 0.5
)
}
\arguments{
\item{noise_dim}{The length of the noise vector per example}

\item{number_channels}{The number of channels in the image (RGB is 3 channels)}

\item{ngf}{The number of feature maps in generator}

\item{dropout_rate}{The dropout rate for each hidden layer}
}
\value{
A torch::nn_module for the DCGAN Generator
}
\description{
Provides a torch::nn_module with a simple deep convolutional neural
net architecture, for use as the default architecture for image data in RGAN.
Architecture inspired by: \url{https://pytorch.org/tutorials/beginner/dcgan_faces_tutorial.html}
}
