% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{DenseMatrixMicrobenchmark}
\alias{DenseMatrixMicrobenchmark}
\title{This class specifies a dense matrix microbenchmark.}
\description{
This class specifies a dense matrix microbenchmark.
}
\section{Fields}{

\describe{
\item{\code{active}}{a logical indicating whether the microbenchmark is to be
executed (TRUE) or not (FALSE).}

\item{\code{benchmarkName}}{a character string that is the name of the
microbenchmark.}

\item{\code{benchmarkDescription}}{a character string describing the microbenchmark.}

\item{\code{dimensionParameters}}{an integer vector specifying the dimension
parameters the microbenchmark uses to define the matrix dimensions to be
tested with.}

\item{\code{numberOfTrials}}{an integer vector specifying the number of performance
trials conducted for each matrix to be tested.  Must be the same length as
\code{dimensionParameters}.}

\item{\code{numberOfWarmupTrials}}{an integer vector specifying the number of warmup
trials to be performed for each matrix to be tested.}

\item{\code{allocatorFunction}}{the function that allocates and initializes input to
the benchmark function.  The function takes a
\code{DenseMatrixMicrobenchmark} object and an integer index indicating
which matrix dimension parameter from \code{dimensionParameters} should
be used to generate the matrix.}

\item{\code{benchmarkFunction}}{the benchmark function which executes the
functionality to be timed.  The function takes a
\code{DenseMatrixMicrobenchmark} and a list of kernel parameters
returned by the allocator function.}
}}

