% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{SolveMicrobenchmark}
\alias{SolveMicrobenchmark}
\title{Conducts a single performance trial with the dense matrix kernel for
computing the solution to a system of linear equations with multiple
right-hand sides}
\usage{
SolveMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the dense matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the dense matrix kernel}
}
\description{
\code{SolveMicrobenchmark} conducts a single performance trial of the
solve dense matrix kernel for the matrix given in the
\code{kernelParameters} parameter.  The function times the single function
call \code{solve(kernelParameters$A, kernelParameters$B, LAPACK=TRUE)}.
}
\examples{
\dontrun{
# Allocate input to the linear solve microbenchmark for the
# first matrix size to be tested
microbenchmarks <- GetDenseMatrixDefaultMicrobenchmarks()
kernelParameters <- SolveAllocator(microbenchmarks[["solve"]], 1)
# Execute the microbenchmark
timings <- SolveMicrobenchmark(microbenchmarks[["solve"]], kernelParameters)
}

}
