% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRTList.R
\name{getResults}
\alias{getResults}
\alias{getResults,HRTList-method}
\title{Get averaged HRT parameters}
\usage{
getResults(
  HRTListObj,
  type = "class",
  TT = FALSE,
  nTS = FALSE,
  safe = TRUE,
  pmax = 0.05,
  num = FALSE,
  coTO = COTO,
  coTS = COTS,
  coTT = COTT
)

\S4method{getResults}{HRTList}(
  HRTListObj,
  type = "class",
  TT = FALSE,
  nTS = FALSE,
  safe = TRUE,
  pmax = 0.05,
  num = FALSE,
  coTO = COTO,
  coTS = COTS,
  coTT = COTT
)
}
\arguments{
\item{HRTListObj}{HRTList object}

\item{type}{(String) Determining the amount of output: 'class' gives the HRT class, 'parameter' the parameter values and 'full' additionally the p-values describing parameter reliability}

\item{TT}{(Boolean) Should TT be given?}

\item{nTS}{(Boolean) Should the normalised TS (nTS) be given or used for the determination of the HRT class?}

\item{safe}{(Boolean) Should all values be given regardless of reliability checks? Note, that 'safe' is ignored when the type is 'full'.}

\item{pmax}{(Numeric) The significance level}

\item{num}{(Boolean) Should the results be numeric? This forces the results to stay numeric, but sets not reliable values as NA, if 'safe' is TRUE. Forced numeric values cannot be combined with type 'class'.}

\item{coTO}{(Numeric) Cut-off value for TO}

\item{coTS}{(Numeric) Cut-off value for TS and nTS}

\item{coTT}{(Numeric) Cut-off value for TT}
}
\value{
(Named vector, character or numeric) Either HRT classes, HRT parameter values and/or p-values
}
\description{
Returns the HRT parameters of the HRTList. Turbulence onset is calculated for
each HRT object and then averaged, turbulence slope is calculated via
averaging the intervals of all HRT objects to one HRT object and then
estimating the maximal slope.
}
\examples{
# You need an HRTList
hrtl <- vectorToHRT(testdataLong, testdataLong_Ann)

# Get the HRT classes of your HRTList
getResults(hrtl)
getResults(hrtl, TT = TRUE)

# Get the HRT parameter values of your HRTList
getResults(hrtl, type = "parameter", TT = TRUE)

}
