% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paletteFunction.R
\name{image_palette}
\alias{image_palette}
\title{Create image palette}
\usage{
image_palette(image, n, choice = mean, volume = FALSE)
}
\arguments{
\item{image}{Matrix The image from which the palette will be extracted from. Should
be a 3 (or more) dimensional matrix. The output of a function such as \code{readJPG()}
or \code{readPNG()} are suitable as \code{image}.}

\item{n}{Integer The number of discrete colors to be extracted from the image.}

\item{choice}{Function Defines how the color will be chosen from the final color cubes.
The default choice is to take the \code{mean} value of the image cube, but other choices
may return a subjectively superior scale. Try \code{median}, or \code{min}, or \code{max}, or
whatever summary statistic suits your fancy.}

\item{volume}{Logical volume controls the method for choosing which color cube to split
at each iteration of the algorithm. The default choice (when \code{volume = FALSE}) is to
choose the cube based on which cube contains the largest extent (that is, the largest range
of some color). When \code{volume = TRUE}, the cube with the largest volume is chosen to split.
Occasionally, setting to \code{TRUE} returns a better palette.}
}
\description{
Image palette function
}
\details{
Uses the median cut algorithm to create \code{n} discrete colors based on colors
present in an image. See \code{\link{median_cut}} for more details.
}
\examples{
img <- jpeg::readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))
display_image(img)
scales::show_col(image_palette(img, n=5))
}
\seealso{
\code{\link{median_cut}}
}

