/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.benchmarking.BaseDisaggregation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class SsfDisaggregation<S extends ISsf>
extends BaseDisaggregation
implements ISsf {
    private S ssf_;

    public SsfDisaggregation(int conv, S ssf) {
        super(conv);
        this.ssf_ = ssf;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.ssf_.diffuseConstraints(b.extract(1, b.getRowsCount(), 0, b.getColumnsCount()));
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.ssf_.fullQ(pos, qm.extract(1, qm.getRowsCount(), 1, qm.getColumnsCount()));
    }

    public S getInternalSsf() {
        return this.ssf_;
    }

    @Override
    public int getNonStationaryDim() {
        return this.ssf_.getNonStationaryDim();
    }

    @Override
    public int getStateDim() {
        return 1 + this.ssf_.getStateDim();
    }

    @Override
    public int getTransitionResCount() {
        return this.ssf_.getTransitionResCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.ssf_.getTransitionResDim();
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return this.ssf_.hasTransitionRes(pos);
    }

    @Override
    public boolean hasW() {
        return this.ssf_.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.ssf_.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.ssf_.isTransitionResidualTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.ssf_.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        SubMatrix l = lm.extract(1, lm.getRowsCount(), 1, lm.getColumnsCount());
        this.ssf_.L(pos, k.drop(1, 0), l);
        DataBlock c0 = lm.column(0);
        c0.set(0.0);
        double s = -k.get(0);
        if (pos % this.conversion != 0) {
            if ((pos + 1) % this.conversion != 0) {
                c0.set(0, 1.0);
            }
            c0.sub(k);
        }
        if ((pos + 1) % this.conversion != 0) {
            s += 1.0;
        }
        DataBlock r0 = lm.row(0).drop(1, 0);
        r0.set(0.0);
        this.ssf_.XpZd(pos, r0, s);
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.ssf_.Pf0(pf0.extract(1, pf0.getRowsCount(), 1, pf0.getColumnsCount()));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.ssf_.Pi0(pi0.extract(1, pi0.getRowsCount(), 1, pi0.getColumnsCount()));
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.ssf_.Q(pos, qm);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        if (this.ssf_.hasR()) {
            this.ssf_.R(pos, rv);
            rv.add(1);
        } else {
            int n = this.ssf_.getStateDim();
            for (int i = 0; i < n; ++i) {
                rv.set(i, i + 1);
            }
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.ssf_.T(pos, tr.extract(1, tr.getRowsCount(), 1, tr.getColumnsCount()));
        if ((pos + 1) % this.conversion != 0) {
            this.ssf_.Z(pos, tr.row(0).drop(1, 0));
            if (pos % this.conversion != 0) {
                tr.set(0, 0, 1.0);
            }
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        SubMatrix v = vm.extract(1, vm.getRowsCount(), 1, vm.getColumnsCount());
        if (pos % this.conversion == 0) {
            DataBlock v0 = vm.row(0).drop(1, 0);
            this.ssf_.ZM(pos, v, v0);
            vm.set(0, 0, this.ssf_.ZX(pos, v0));
            this.ssf_.TX(pos, v0);
            vm.column(0).drop(1, 0).copy(v0);
        } else if ((pos + 1) % this.conversion != 0) {
            DataBlock r0 = vm.row(0).drop(1, 0);
            double zv0 = this.ssf_.ZX(pos, r0);
            this.ssf_.ZM(pos, v, r0);
            vm.add(0, 0, 2.0 * zv0 + this.ssf_.ZX(pos, r0));
            this.ssf_.TX(pos, r0);
            DataBlock c0 = vm.column(0).drop(1, 0);
            this.ssf_.TX(pos, c0);
            c0.add(r0);
            r0.copy(c0);
        } else {
            vm.row(0).set(0.0);
            vm.column(0).set(0.0);
        }
        this.ssf_.TVT(pos, v);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        DataBlock xc = x.drop(1, 0);
        if ((pos + 1) % this.conversion != 0) {
            double s = this.ssf_.ZX(pos, xc);
            if (pos % this.conversion == 0) {
                x.set(0, s);
            } else {
                x.add(0, s);
            }
        } else {
            x.set(0, 0.0);
        }
        this.ssf_.TX(pos, xc);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        SubMatrix v = vm.extract(1, vm.getRowsCount(), 1, vm.getColumnsCount());
        this.ssf_.VpZdZ(pos, v, d);
        if (pos % this.conversion != 0) {
            vm.add(0, 0, d);
            this.ssf_.XpZd(pos, vm.column(0).drop(1, 0), d);
            this.ssf_.XpZd(pos, vm.row(0).drop(1, 0), d);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        this.ssf_.W(pos, wv);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        this.ssf_.XpZd(pos, x.drop(1, 0), d);
        if (pos % this.conversion != 0) {
            x.add(0, d);
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        DataBlock xc = x.drop(1, 0);
        this.ssf_.XT(pos, xc);
        if ((pos + 1) % this.conversion != 0) {
            this.ssf_.XpZd(pos, xc, x.get(0));
            if (pos % this.conversion == 0) {
                x.set(0, 0.0);
            }
        } else {
            x.set(0, 0.0);
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        if (pos % this.conversion != 0) {
            z.set(0, 1.0);
        }
        this.ssf_.Z(pos, z.drop(1, 0));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        if (pos % this.conversion == 0) {
            x.set(0.0);
        } else {
            x.copy(m.row(0));
        }
        SubMatrix q = m.extract(1, m.getRowsCount(), 0, m.getColumnsCount());
        DataBlockIterator c = q.columns();
        DataBlock cur = c.getData();
        do {
            x.add(c.getPosition(), this.ssf_.ZX(pos, cur));
        } while (c.next());
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        SubMatrix v = vm.extract(1, vm.getRowsCount(), 1, vm.getColumnsCount());
        if (pos % this.conversion == 0) {
            return this.ssf_.ZVZ(pos, v);
        }
        double r = vm.get(0, 0);
        r += 2.0 * this.ssf_.ZX(pos, vm.row(0).drop(1, 0));
        return r += this.ssf_.ZVZ(pos, v);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double r = pos % this.conversion == 0 ? 0.0 : x.get(0);
        return r + this.ssf_.ZX(pos, x.drop(1, 0));
    }
}

