% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpca_d.R
\name{mlpca_d}
\alias{mlpca_d}
\title{Maximum likelihood principal component analysis for mode D error conditions}
\usage{
mlpca_d(X, Cov, p)
}
\arguments{
\item{X}{IxJ matrix of measurements}

\item{Cov}{JxJ matrix of measurement error covariance, which is commom to all
rows}

\item{p}{Rank of the model's subspace}
}
\value{
The parameters returned are the results of SVD on the estimated
subspace. The quantity Ssq represents the sum of squares of weighted
residuals.
}
\description{
Performs maximum likelihood principal components analysis for
mode D error conditions (commom row covariance matrices).
Employs rotation and scaling of the original data.
}
\details{
The returned parameters, U, S and V, are analogs to the
truncated SVD solution, but have somewhat different properties since they
represent the MLPCA solution. In particular, the solutions for different
values of p are not necessarily nested (the rank 1 solution may not be in
the space of the rank 2 solution) and the eigenvectors do not necessarily
account for decreasing amounts of variance, since MLPCA is a subspace
modeling technique and not a variance modeling technique.
}
\examples{
  library(RMLPCA)
  data(data_clean)
  data(data_error_d)
  # covariance matrix
  data(cov_d)
  data(data_cleaned_mlpca_d)
  # data that you will usually have on hands
  data_noisy <- data_clean + data_error_d

  # run mlpca_c with rank p = 5
  results <- RMLPCA::mlpca_d(
    X = data_noisy,
    Cov = cov_d,
    p = 2
  )

  # estimated clean dataset
  data_cleaned_mlpca <- results$U \%*\% results$S \%*\% t(results$V)
}
\references{
Wentzell, P. D.
"Other topics in soft-modeling: maximum likelihood-based soft-modeling
methods." (2009): 507-558.
}
