% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_getter.R
\name{getEmpiricTik}
\alias{getEmpiricTik}
\alias{getTik}
\title{Get the tik}
\usage{
getEmpiricTik(outMixtComp)

getTik(outMixtComp, log = TRUE)
}
\arguments{
\item{outMixtComp}{object of class \emph{MixtCompLearn} or \emph{MixtComp} obtained using \code{mixtCompLearn} or
\code{mixtCompPredict} functions from \code{RMixtComp} package or \code{rmcMultiRun} from \code{RMixtCompIO} package.}

\item{log}{if TRUE, log(tik) are returned}
}
\value{
a matrix containing the tik for each individual (in row) and each class (in column).
}
\description{
Get the a posteriori probability to belong to each class for each individual
}
\details{
\emph{getTik} returns a posteriori probabilities computed with the returned parameters. \emph{getEmpiricTik} returns
an estimation based on the sampled z_i during the algorithm.
}
\examples{
if (requireNamespace("RMixtCompIO", quietly = TRUE)) {
  dataLearn <- list(
    var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
    var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
  )

  model <- list(
    var1 = list(type = "Gaussian", paramStr = ""),
    var2 = list(type = "Poisson", paramStr = "")
  )

  algo <- list(
    nClass = 2,
    nInd = 100,
    nbBurnInIter = 100,
    nbIter = 100,
    nbGibbsBurnInIter = 100,
    nbGibbsIter = 100,
    nInitPerClass = 3,
    nSemTry = 20,
    confidenceLevel = 0.95,
    ratioStableCriterion = 0.95,
    nStableCriterion = 10,
    mode = "learn"
  )

  resLearn <-RMixtCompIO::rmcMultiRun(algo, dataLearn, model, nRun = 3)

  # get tik
  tikEmp <- getEmpiricTik(resLearn)
  tik <- getTik(resLearn, log = FALSE)
}

}
\seealso{
\code{\link{heatmapTikSorted}}

Other getter: 
\code{\link{getBIC}()},
\code{\link{getCompletedData}()},
\code{\link{getMixtureDensity}()},
\code{\link{getParam}()},
\code{\link{getPartition}()},
\code{\link{getType}()}
}
\author{
Quentin Grimonprez
}
\concept{getter}
