% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{transform_response}
\alias{transform_response}
\title{Transforms a response variable into a valid factor that can be
processed downstream.}
\usage{
transform_response(response, .condition = NULL)
}
\arguments{
\item{response}{A factor, integer or character vector of categories.}
}
\value{
\code{factor} of levels \verb{(0,1)}, where 1 represents the condition of
interest and 0 absence of it.
}
\description{
\code{transform_response} transforms response so that it can be processed in
further steps. Function transforms input into a \code{factor} of values 1 and 0
corresponding to the condition of interest and absence of it respectively.
}
\details{
By default function takes some assumption on how to make transformation,
depending on the class of \code{response}:
\itemize{
\item factor. Function considers the condition of interest first level in factor.
\item integer. Function considers the condition of interest the \code{min} value of\
response.
\item character. Function considers the condition of interest the first value in
\code{unique(response)} after using \code{sort}.
}
}
\keyword{internal}
