% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_omdb_item.R
\name{get_omdb_item}
\alias{get_omdb_item}
\title{Get OMDB Item}
\usage{
get_omdb_item(omdb_id, include_image = TRUE,
  API_KEY = Sys.getenv("API_KEY"))
}
\arguments{
\item{omdb_id}{String with the omdb_id for a movie/series.}

\item{include_image}{If TRUE, the result includes an image of the movie/series. Default: TRUE.}

\item{API_KEY}{OMBD Api Key. Default: Get the Api Key from system environment. Use Sys.setenv('API_KEY' = 'XXXXX'). More information in: http://www.omdbapi.com/apikey.aspx}
}
\value{
If include_image is TRUE, returns a list with a tibble with the movie information and a image of the film. If include_image is FALSE, only returns the tibble.
}
\description{
This function searches OMDB Movies/Series by ID.
}
\examples{
\dontrun{
get_omdb_item('tt0120338')
}
}
\author{
Alberto Almuiña
}
